/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ExperimentExecutionActionTargetDetailsError;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ExperimentExecutionActionTargetDetailsProperties
implements JsonSerializable<ExperimentExecutionActionTargetDetailsProperties> {
    private String status;
    private String target;
    private OffsetDateTime targetFailedTime;
    private OffsetDateTime targetCompletedTime;
    private ExperimentExecutionActionTargetDetailsError error;

    private ExperimentExecutionActionTargetDetailsProperties() {
    }

    public String status() {
        return this.status;
    }

    public String target() {
        return this.target;
    }

    public OffsetDateTime targetFailedTime() {
        return this.targetFailedTime;
    }

    public OffsetDateTime targetCompletedTime() {
        return this.targetCompletedTime;
    }

    public ExperimentExecutionActionTargetDetailsError error() {
        return this.error;
    }

    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ExperimentExecutionActionTargetDetailsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExperimentExecutionActionTargetDetailsProperties)jsonReader.readObject(reader -> {
            ExperimentExecutionActionTargetDetailsProperties deserializedExperimentExecutionActionTargetDetailsProperties = new ExperimentExecutionActionTargetDetailsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedExperimentExecutionActionTargetDetailsProperties.status = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedExperimentExecutionActionTargetDetailsProperties.target = reader.getString();
                    continue;
                }
                if ("targetFailedTime".equals(fieldName)) {
                    deserializedExperimentExecutionActionTargetDetailsProperties.targetFailedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("targetCompletedTime".equals(fieldName)) {
                    deserializedExperimentExecutionActionTargetDetailsProperties.targetCompletedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedExperimentExecutionActionTargetDetailsProperties.error = ExperimentExecutionActionTargetDetailsError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExperimentExecutionActionTargetDetailsProperties;
        });
    }
}

