/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.chaos.fluent.models.ExperimentInner;
import com.azure.resourcemanager.chaos.models.ChaosExperimentStep;
import com.azure.resourcemanager.chaos.models.ChaosTargetSelector;
import com.azure.resourcemanager.chaos.models.ProvisioningState;
import com.azure.resourcemanager.chaos.models.ResourceIdentity;
import java.util.List;
import java.util.Map;

public interface Experiment {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ResourceIdentity identity();

    public SystemData systemData();

    public ProvisioningState provisioningState();

    public List<ChaosExperimentStep> steps();

    public List<ChaosTargetSelector> selectors();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ExperimentInner innerModel();

    public Update update();

    public Experiment refresh();

    public Experiment refresh(Context var1);

    public void cancel();

    public void cancel(Context var1);

    public void start();

    public void start(Context var1);

    public static interface UpdateStages {

        public static interface WithIdentity {
            public Update withIdentity(ResourceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity {
        public Experiment apply();

        public Experiment apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIdentity {
            public WithCreate withIdentity(ResourceIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity {
            public Experiment create();

            public Experiment create(Context var1);
        }

        public static interface WithSelectors {
            public WithCreate withSelectors(List<ChaosTargetSelector> var1);
        }

        public static interface WithSteps {
            public WithSelectors withSteps(List<ChaosExperimentStep> var1);
        }

        public static interface WithResourceGroup {
            public WithSteps withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithSteps,
    DefinitionStages.WithSelectors,
    DefinitionStages.WithCreate {
    }
}

