/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ChaosExperimentAction;
import com.azure.resourcemanager.chaos.models.ExperimentActionType;
import com.azure.resourcemanager.chaos.models.KeyValuePair;
import java.io.IOException;
import java.util.List;

public final class DiscreteAction
extends ChaosExperimentAction {
    private ExperimentActionType type = ExperimentActionType.DISCRETE;
    private List<KeyValuePair> parameters;
    private String selectorId;
    private static final ClientLogger LOGGER = new ClientLogger(DiscreteAction.class);

    @Override
    public ExperimentActionType type() {
        return this.type;
    }

    public List<KeyValuePair> parameters() {
        return this.parameters;
    }

    public DiscreteAction withParameters(List<KeyValuePair> parameters) {
        this.parameters = parameters;
        return this;
    }

    public String selectorId() {
        return this.selectorId;
    }

    public DiscreteAction withSelectorId(String selectorId) {
        this.selectorId = selectorId;
        return this;
    }

    @Override
    public DiscreteAction withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public void validate() {
        if (this.parameters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parameters in model DiscreteAction"));
        }
        this.parameters().forEach(e -> e.validate());
        if (this.selectorId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectorId in model DiscreteAction"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model DiscreteAction"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("selectorId", this.selectorId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static DiscreteAction fromJson(JsonReader jsonReader) throws IOException {
        return (DiscreteAction)jsonReader.readObject(reader -> {
            DiscreteAction deserializedDiscreteAction = new DiscreteAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDiscreteAction.withName(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedDiscreteAction.parameters = parameters = reader.readArray(reader1 -> KeyValuePair.fromJson(reader1));
                    continue;
                }
                if ("selectorId".equals(fieldName)) {
                    deserializedDiscreteAction.selectorId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDiscreteAction.type = ExperimentActionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiscreteAction;
        });
    }
}

