/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ChaosExperimentAction;
import com.azure.resourcemanager.chaos.models.ExperimentActionType;
import java.io.IOException;
import java.time.Duration;

public final class DelayAction
extends ChaosExperimentAction {
    private ExperimentActionType type = ExperimentActionType.DELAY;
    private Duration duration;
    private static final ClientLogger LOGGER = new ClientLogger(DelayAction.class);

    @Override
    public ExperimentActionType type() {
        return this.type;
    }

    public Duration duration() {
        return this.duration;
    }

    public DelayAction withDuration(Duration duration) {
        this.duration = duration;
        return this;
    }

    @Override
    public DelayAction withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public void validate() {
        if (this.duration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property duration in model DelayAction"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model DelayAction"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("duration", CoreUtils.durationToStringWithDays((Duration)this.duration));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static DelayAction fromJson(JsonReader jsonReader) throws IOException {
        return (DelayAction)jsonReader.readObject(reader -> {
            DelayAction deserializedDelayAction = new DelayAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDelayAction.withName(reader.getString());
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedDelayAction.duration = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDelayAction.type = ExperimentActionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDelayAction;
        });
    }
}

