/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ChaosExperimentAction;
import com.azure.resourcemanager.chaos.models.ExperimentActionType;
import com.azure.resourcemanager.chaos.models.KeyValuePair;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class ContinuousAction
extends ChaosExperimentAction {
    private ExperimentActionType type = ExperimentActionType.CONTINUOUS;
    private Duration duration;
    private List<KeyValuePair> parameters;
    private String selectorId;
    private static final ClientLogger LOGGER = new ClientLogger(ContinuousAction.class);

    @Override
    public ExperimentActionType type() {
        return this.type;
    }

    public Duration duration() {
        return this.duration;
    }

    public ContinuousAction withDuration(Duration duration) {
        this.duration = duration;
        return this;
    }

    public List<KeyValuePair> parameters() {
        return this.parameters;
    }

    public ContinuousAction withParameters(List<KeyValuePair> parameters) {
        this.parameters = parameters;
        return this;
    }

    public String selectorId() {
        return this.selectorId;
    }

    public ContinuousAction withSelectorId(String selectorId) {
        this.selectorId = selectorId;
        return this;
    }

    @Override
    public ContinuousAction withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public void validate() {
        if (this.duration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property duration in model ContinuousAction"));
        }
        if (this.parameters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parameters in model ContinuousAction"));
        }
        this.parameters().forEach(e -> e.validate());
        if (this.selectorId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectorId in model ContinuousAction"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ContinuousAction"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("duration", CoreUtils.durationToStringWithDays((Duration)this.duration));
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("selectorId", this.selectorId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ContinuousAction fromJson(JsonReader jsonReader) throws IOException {
        return (ContinuousAction)jsonReader.readObject(reader -> {
            ContinuousAction deserializedContinuousAction = new ContinuousAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedContinuousAction.withName(reader.getString());
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedContinuousAction.duration = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedContinuousAction.parameters = parameters = reader.readArray(reader1 -> KeyValuePair.fromJson(reader1));
                    continue;
                }
                if ("selectorId".equals(fieldName)) {
                    deserializedContinuousAction.selectorId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContinuousAction.type = ExperimentActionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContinuousAction;
        });
    }
}

