/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ChaosTargetFilter;
import com.azure.resourcemanager.chaos.models.ChaosTargetSimpleFilterParameters;
import com.azure.resourcemanager.chaos.models.FilterType;
import java.io.IOException;

public final class ChaosTargetSimpleFilter
extends ChaosTargetFilter {
    private FilterType type = FilterType.SIMPLE;
    private ChaosTargetSimpleFilterParameters parameters;

    @Override
    public FilterType type() {
        return this.type;
    }

    public ChaosTargetSimpleFilterParameters parameters() {
        return this.parameters;
    }

    public ChaosTargetSimpleFilter withParameters(ChaosTargetSimpleFilterParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public void validate() {
        if (this.parameters() != null) {
            this.parameters().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static ChaosTargetSimpleFilter fromJson(JsonReader jsonReader) throws IOException {
        return (ChaosTargetSimpleFilter)jsonReader.readObject(reader -> {
            ChaosTargetSimpleFilter deserializedChaosTargetSimpleFilter = new ChaosTargetSimpleFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedChaosTargetSimpleFilter.type = FilterType.fromString(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedChaosTargetSimpleFilter.parameters = ChaosTargetSimpleFilterParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChaosTargetSimpleFilter;
        });
    }
}

