/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ChaosTargetFilter;
import com.azure.resourcemanager.chaos.models.ChaosTargetListSelector;
import com.azure.resourcemanager.chaos.models.ChaosTargetQuerySelector;
import com.azure.resourcemanager.chaos.models.SelectorType;
import java.io.IOException;

public class ChaosTargetSelector
implements JsonSerializable<ChaosTargetSelector> {
    private SelectorType type = SelectorType.fromString("ChaosTargetSelector");
    private String id;
    private ChaosTargetFilter filter;
    private static final ClientLogger LOGGER = new ClientLogger(ChaosTargetSelector.class);

    public SelectorType type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public ChaosTargetSelector withId(String id) {
        this.id = id;
        return this;
    }

    public ChaosTargetFilter filter() {
        return this.filter;
    }

    public ChaosTargetSelector withFilter(ChaosTargetFilter filter) {
        this.filter = filter;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model ChaosTargetSelector"));
        }
        if (this.filter() != null) {
            this.filter().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("filter", (JsonSerializable)this.filter);
        return jsonWriter.writeEndObject();
    }

    public static ChaosTargetSelector fromJson(JsonReader jsonReader) throws IOException {
        return (ChaosTargetSelector)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ChaosTargetSelector chaosTargetSelector;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("List".equals(discriminatorValue)) {
                    chaosTargetSelector = ChaosTargetListSelector.fromJson(readerToUse.reset());
                    return chaosTargetSelector;
                }
                if ("Query".equals(discriminatorValue)) {
                    chaosTargetSelector = ChaosTargetQuerySelector.fromJson(readerToUse.reset());
                    return chaosTargetSelector;
                }
                chaosTargetSelector = ChaosTargetSelector.fromJsonKnownDiscriminator(readerToUse.reset());
                return chaosTargetSelector;
            }
        });
    }

    static ChaosTargetSelector fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ChaosTargetSelector)jsonReader.readObject(reader -> {
            ChaosTargetSelector deserializedChaosTargetSelector = new ChaosTargetSelector();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedChaosTargetSelector.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedChaosTargetSelector.type = SelectorType.fromString(reader.getString());
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedChaosTargetSelector.filter = ChaosTargetFilter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChaosTargetSelector;
        });
    }
}

