/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ChaosTargetFilter;
import com.azure.resourcemanager.chaos.models.ChaosTargetSelector;
import com.azure.resourcemanager.chaos.models.SelectorType;
import java.io.IOException;
import java.util.List;

public final class ChaosTargetQuerySelector
extends ChaosTargetSelector {
    private SelectorType type = SelectorType.QUERY;
    private String queryString;
    private List<String> subscriptionIds;
    private static final ClientLogger LOGGER = new ClientLogger(ChaosTargetQuerySelector.class);

    @Override
    public SelectorType type() {
        return this.type;
    }

    public String queryString() {
        return this.queryString;
    }

    public ChaosTargetQuerySelector withQueryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public List<String> subscriptionIds() {
        return this.subscriptionIds;
    }

    public ChaosTargetQuerySelector withSubscriptionIds(List<String> subscriptionIds) {
        this.subscriptionIds = subscriptionIds;
        return this;
    }

    @Override
    public ChaosTargetQuerySelector withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ChaosTargetQuerySelector withFilter(ChaosTargetFilter filter) {
        super.withFilter(filter);
        return this;
    }

    @Override
    public void validate() {
        if (this.queryString() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property queryString in model ChaosTargetQuerySelector"));
        }
        if (this.subscriptionIds() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionIds in model ChaosTargetQuerySelector"));
        }
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model ChaosTargetQuerySelector"));
        }
        if (this.filter() != null) {
            this.filter().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("filter", (JsonSerializable)this.filter());
        jsonWriter.writeStringField("queryString", this.queryString);
        jsonWriter.writeArrayField("subscriptionIds", this.subscriptionIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ChaosTargetQuerySelector fromJson(JsonReader jsonReader) throws IOException {
        return (ChaosTargetQuerySelector)jsonReader.readObject(reader -> {
            ChaosTargetQuerySelector deserializedChaosTargetQuerySelector = new ChaosTargetQuerySelector();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedChaosTargetQuerySelector.withId(reader.getString());
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedChaosTargetQuerySelector.withFilter(ChaosTargetFilter.fromJson(reader));
                    continue;
                }
                if ("queryString".equals(fieldName)) {
                    deserializedChaosTargetQuerySelector.queryString = reader.getString();
                    continue;
                }
                if ("subscriptionIds".equals(fieldName)) {
                    List subscriptionIds;
                    deserializedChaosTargetQuerySelector.subscriptionIds = subscriptionIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedChaosTargetQuerySelector.type = SelectorType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChaosTargetQuerySelector;
        });
    }
}

