/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ChaosTargetFilter;
import com.azure.resourcemanager.chaos.models.ChaosTargetSelector;
import com.azure.resourcemanager.chaos.models.SelectorType;
import com.azure.resourcemanager.chaos.models.TargetReference;
import java.io.IOException;
import java.util.List;

public final class ChaosTargetListSelector
extends ChaosTargetSelector {
    private SelectorType type = SelectorType.LIST;
    private List<TargetReference> targets;
    private static final ClientLogger LOGGER = new ClientLogger(ChaosTargetListSelector.class);

    @Override
    public SelectorType type() {
        return this.type;
    }

    public List<TargetReference> targets() {
        return this.targets;
    }

    public ChaosTargetListSelector withTargets(List<TargetReference> targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public ChaosTargetListSelector withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ChaosTargetListSelector withFilter(ChaosTargetFilter filter) {
        super.withFilter(filter);
        return this;
    }

    @Override
    public void validate() {
        if (this.targets() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targets in model ChaosTargetListSelector"));
        }
        this.targets().forEach(e -> e.validate());
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model ChaosTargetListSelector"));
        }
        if (this.filter() != null) {
            this.filter().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("filter", (JsonSerializable)this.filter());
        jsonWriter.writeArrayField("targets", this.targets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ChaosTargetListSelector fromJson(JsonReader jsonReader) throws IOException {
        return (ChaosTargetListSelector)jsonReader.readObject(reader -> {
            ChaosTargetListSelector deserializedChaosTargetListSelector = new ChaosTargetListSelector();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedChaosTargetListSelector.withId(reader.getString());
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedChaosTargetListSelector.withFilter(ChaosTargetFilter.fromJson(reader));
                    continue;
                }
                if ("targets".equals(fieldName)) {
                    List targets;
                    deserializedChaosTargetListSelector.targets = targets = reader.readArray(reader1 -> TargetReference.fromJson(reader1));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedChaosTargetListSelector.type = SelectorType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChaosTargetListSelector;
        });
    }
}

