/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ChaosExperimentBranch;
import java.io.IOException;
import java.util.List;

public final class ChaosExperimentStep
implements JsonSerializable<ChaosExperimentStep> {
    private String name;
    private List<ChaosExperimentBranch> branches;
    private static final ClientLogger LOGGER = new ClientLogger(ChaosExperimentStep.class);

    public String name() {
        return this.name;
    }

    public ChaosExperimentStep withName(String name) {
        this.name = name;
        return this;
    }

    public List<ChaosExperimentBranch> branches() {
        return this.branches;
    }

    public ChaosExperimentStep withBranches(List<ChaosExperimentBranch> branches) {
        this.branches = branches;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ChaosExperimentStep"));
        }
        if (this.branches() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property branches in model ChaosExperimentStep"));
        }
        this.branches().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("branches", this.branches, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ChaosExperimentStep fromJson(JsonReader jsonReader) throws IOException {
        return (ChaosExperimentStep)jsonReader.readObject(reader -> {
            ChaosExperimentStep deserializedChaosExperimentStep = new ChaosExperimentStep();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedChaosExperimentStep.name = reader.getString();
                    continue;
                }
                if ("branches".equals(fieldName)) {
                    List branches;
                    deserializedChaosExperimentStep.branches = branches = reader.readArray(reader1 -> ChaosExperimentBranch.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChaosExperimentStep;
        });
    }
}

