/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ChaosExperimentAction;
import java.io.IOException;
import java.util.List;

public final class ChaosExperimentBranch
implements JsonSerializable<ChaosExperimentBranch> {
    private String name;
    private List<ChaosExperimentAction> actions;
    private static final ClientLogger LOGGER = new ClientLogger(ChaosExperimentBranch.class);

    public String name() {
        return this.name;
    }

    public ChaosExperimentBranch withName(String name) {
        this.name = name;
        return this;
    }

    public List<ChaosExperimentAction> actions() {
        return this.actions;
    }

    public ChaosExperimentBranch withActions(List<ChaosExperimentAction> actions) {
        this.actions = actions;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ChaosExperimentBranch"));
        }
        if (this.actions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property actions in model ChaosExperimentBranch"));
        }
        this.actions().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ChaosExperimentBranch fromJson(JsonReader jsonReader) throws IOException {
        return (ChaosExperimentBranch)jsonReader.readObject(reader -> {
            ChaosExperimentBranch deserializedChaosExperimentBranch = new ChaosExperimentBranch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedChaosExperimentBranch.name = reader.getString();
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedChaosExperimentBranch.actions = actions = reader.readArray(reader1 -> ChaosExperimentAction.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChaosExperimentBranch;
        });
    }
}

