/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ContinuousAction;
import com.azure.resourcemanager.chaos.models.DelayAction;
import com.azure.resourcemanager.chaos.models.DiscreteAction;
import com.azure.resourcemanager.chaos.models.ExperimentActionType;
import java.io.IOException;

public class ChaosExperimentAction
implements JsonSerializable<ChaosExperimentAction> {
    private ExperimentActionType type = ExperimentActionType.fromString("ChaosExperimentAction");
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(ChaosExperimentAction.class);

    public ExperimentActionType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public ChaosExperimentAction withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ChaosExperimentAction"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ChaosExperimentAction fromJson(JsonReader jsonReader) throws IOException {
        return (ChaosExperimentAction)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ChaosExperimentAction chaosExperimentAction;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("continuous".equals(discriminatorValue)) {
                    chaosExperimentAction = ContinuousAction.fromJson(readerToUse.reset());
                    return chaosExperimentAction;
                }
                if ("delay".equals(discriminatorValue)) {
                    chaosExperimentAction = DelayAction.fromJson(readerToUse.reset());
                    return chaosExperimentAction;
                }
                if ("discrete".equals(discriminatorValue)) {
                    chaosExperimentAction = DiscreteAction.fromJson(readerToUse.reset());
                    return chaosExperimentAction;
                }
                chaosExperimentAction = ChaosExperimentAction.fromJsonKnownDiscriminator(readerToUse.reset());
                return chaosExperimentAction;
            }
        });
    }

    static ChaosExperimentAction fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ChaosExperimentAction)jsonReader.readObject(reader -> {
            ChaosExperimentAction deserializedChaosExperimentAction = new ChaosExperimentAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedChaosExperimentAction.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedChaosExperimentAction.type = ExperimentActionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChaosExperimentAction;
        });
    }
}

