/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ActionStatus;
import java.io.IOException;
import java.util.List;

public final class BranchStatus
implements JsonSerializable<BranchStatus> {
    private String branchName;
    private String branchId;
    private String status;
    private List<ActionStatus> actions;

    private BranchStatus() {
    }

    public String branchName() {
        return this.branchName;
    }

    public String branchId() {
        return this.branchId;
    }

    public String status() {
        return this.status;
    }

    public List<ActionStatus> actions() {
        return this.actions;
    }

    public void validate() {
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static BranchStatus fromJson(JsonReader jsonReader) throws IOException {
        return (BranchStatus)jsonReader.readObject(reader -> {
            BranchStatus deserializedBranchStatus = new BranchStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("branchName".equals(fieldName)) {
                    deserializedBranchStatus.branchName = reader.getString();
                    continue;
                }
                if ("branchId".equals(fieldName)) {
                    deserializedBranchStatus.branchId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedBranchStatus.status = reader.getString();
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedBranchStatus.actions = actions = reader.readArray(reader1 -> ActionStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBranchStatus;
        });
    }
}

