/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ExperimentExecutionActionTargetDetailsProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ActionStatus
implements JsonSerializable<ActionStatus> {
    private String actionName;
    private String actionId;
    private String status;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private List<ExperimentExecutionActionTargetDetailsProperties> targets;

    private ActionStatus() {
    }

    public String actionName() {
        return this.actionName;
    }

    public String actionId() {
        return this.actionId;
    }

    public String status() {
        return this.status;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public List<ExperimentExecutionActionTargetDetailsProperties> targets() {
        return this.targets;
    }

    public void validate() {
        if (this.targets() != null) {
            this.targets().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ActionStatus fromJson(JsonReader jsonReader) throws IOException {
        return (ActionStatus)jsonReader.readObject(reader -> {
            ActionStatus deserializedActionStatus = new ActionStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("actionName".equals(fieldName)) {
                    deserializedActionStatus.actionName = reader.getString();
                    continue;
                }
                if ("actionId".equals(fieldName)) {
                    deserializedActionStatus.actionId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedActionStatus.status = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedActionStatus.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedActionStatus.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("targets".equals(fieldName)) {
                    List targets;
                    deserializedActionStatus.targets = targets = reader.readArray(reader1 -> ExperimentExecutionActionTargetDetailsProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActionStatus;
        });
    }
}

