/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.fluent.models.TargetTypeInner;
import java.io.IOException;
import java.util.List;

public final class TargetTypeListResult
implements JsonSerializable<TargetTypeListResult> {
    private List<TargetTypeInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(TargetTypeListResult.class);

    private TargetTypeListResult() {
    }

    public List<TargetTypeInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model TargetTypeListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static TargetTypeListResult fromJson(JsonReader jsonReader) throws IOException {
        return (TargetTypeListResult)jsonReader.readObject(reader -> {
            TargetTypeListResult deserializedTargetTypeListResult = new TargetTypeListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedTargetTypeListResult.value = value = reader.readArray(reader1 -> TargetTypeInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedTargetTypeListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetTypeListResult;
        });
    }
}

