/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.fluent.models.ExperimentExecutionInner;
import java.io.IOException;
import java.util.List;

public final class ExperimentExecutionListResult
implements JsonSerializable<ExperimentExecutionListResult> {
    private List<ExperimentExecutionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ExperimentExecutionListResult.class);

    private ExperimentExecutionListResult() {
    }

    public List<ExperimentExecutionInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ExperimentExecutionListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ExperimentExecutionListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ExperimentExecutionListResult)jsonReader.readObject(reader -> {
            ExperimentExecutionListResult deserializedExperimentExecutionListResult = new ExperimentExecutionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedExperimentExecutionListResult.value = value = reader.readArray(reader1 -> ExperimentExecutionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedExperimentExecutionListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExperimentExecutionListResult;
        });
    }
}

