/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.fluent.models.CapabilityTypeInner;
import java.io.IOException;
import java.util.List;

public final class CapabilityTypeListResult
implements JsonSerializable<CapabilityTypeListResult> {
    private List<CapabilityTypeInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(CapabilityTypeListResult.class);

    private CapabilityTypeListResult() {
    }

    public List<CapabilityTypeInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model CapabilityTypeListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static CapabilityTypeListResult fromJson(JsonReader jsonReader) throws IOException {
        return (CapabilityTypeListResult)jsonReader.readObject(reader -> {
            CapabilityTypeListResult deserializedCapabilityTypeListResult = new CapabilityTypeListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedCapabilityTypeListResult.value = value = reader.readArray(reader1 -> CapabilityTypeInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedCapabilityTypeListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapabilityTypeListResult;
        });
    }
}

