/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.fluent.models.CapabilityInner;
import java.io.IOException;
import java.util.List;

public final class CapabilityListResult
implements JsonSerializable<CapabilityListResult> {
    private List<CapabilityInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(CapabilityListResult.class);

    private CapabilityListResult() {
    }

    public List<CapabilityInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model CapabilityListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static CapabilityListResult fromJson(JsonReader jsonReader) throws IOException {
        return (CapabilityListResult)jsonReader.readObject(reader -> {
            CapabilityListResult deserializedCapabilityListResult = new CapabilityListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedCapabilityListResult.value = value = reader.readArray(reader1 -> CapabilityInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedCapabilityListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapabilityListResult;
        });
    }
}

