/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.chaos.ChaosManager;
import com.azure.resourcemanager.chaos.fluent.TargetsClient;
import com.azure.resourcemanager.chaos.fluent.models.TargetInner;
import com.azure.resourcemanager.chaos.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.chaos.implementation.TargetImpl;
import com.azure.resourcemanager.chaos.models.Target;
import com.azure.resourcemanager.chaos.models.Targets;

public final class TargetsImpl
implements Targets {
    private static final ClientLogger LOGGER = new ClientLogger(TargetsImpl.class);
    private final TargetsClient innerClient;
    private final ChaosManager serviceManager;

    public TargetsImpl(TargetsClient innerClient, ChaosManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Target> getWithResponse(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, Context context) {
        Response<TargetInner> inner = this.serviceClient().getWithResponse(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TargetImpl((TargetInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Target get(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName) {
        TargetInner inner = this.serviceClient().get(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName);
        if (inner != null) {
            return new TargetImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Target> createOrUpdateWithResponse(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, TargetInner resource, Context context) {
        Response<TargetInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, resource, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TargetImpl((TargetInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Target createOrUpdate(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, TargetInner resource) {
        TargetInner inner = this.serviceClient().createOrUpdate(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, resource);
        if (inner != null) {
            return new TargetImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, context);
    }

    @Override
    public void delete(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName) {
        this.serviceClient().delete(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName);
    }

    @Override
    public PagedIterable<Target> list(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName) {
        PagedIterable<TargetInner> inner = this.serviceClient().list(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TargetImpl((TargetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Target> list(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String continuationToken, Context context) {
        PagedIterable<TargetInner> inner = this.serviceClient().list(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, continuationToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TargetImpl((TargetInner)((Object)inner1), this.manager()));
    }

    private TargetsClient serviceClient() {
        return this.innerClient;
    }

    private ChaosManager manager() {
        return this.serviceManager;
    }
}

