/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.chaos.fluent.TargetsClient;
import com.azure.resourcemanager.chaos.fluent.models.TargetInner;
import com.azure.resourcemanager.chaos.implementation.ChaosManagementClientImpl;
import com.azure.resourcemanager.chaos.implementation.models.TargetListResult;
import reactor.core.publisher.Mono;

public final class TargetsClientImpl
implements TargetsClient {
    private final TargetsService service;
    private final ChaosManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(TargetsClientImpl.class);

    TargetsClientImpl(ChaosManagementClientImpl client) {
        this.service = (TargetsService)RestProxy.create(TargetsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TargetInner>> getWithResponseAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TargetInner> getAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName) {
        return this.getWithResponseAsync(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TargetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TargetInner> getWithResponse(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TargetInner get(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName) {
        return (TargetInner)((Object)this.getWithResponse(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TargetInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, TargetInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, "application/json", "application/json", resource, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TargetInner> createOrUpdateAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, TargetInner resource) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, resource).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TargetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TargetInner> createOrUpdateWithResponse(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, TargetInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (resource == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, "application/json", "application/json", resource, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TargetInner createOrUpdate(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, TargetInner resource) {
        return (TargetInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, resource, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName) {
        return this.deleteWithResponseAsync(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName) {
        this.deleteWithResponse(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TargetInner>> listSinglePageAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String continuationToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, continuationToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TargetListResult)res.getValue()).value(), ((TargetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TargetInner> listAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String continuationToken) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, continuationToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TargetInner> listAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName) {
        String continuationToken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, continuationToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TargetInner> listSinglePage(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String continuationToken) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<TargetListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, continuationToken, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TargetListResult)res.getValue()).value(), ((TargetListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TargetInner> listSinglePage(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String continuationToken, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<TargetListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, continuationToken, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TargetListResult)res.getValue()).value(), ((TargetListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TargetInner> list(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName) {
        String continuationToken = null;
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, continuationToken), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TargetInner> list(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String continuationToken, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, continuationToken, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TargetInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TargetListResult)res.getValue()).value(), ((TargetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TargetInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<TargetListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TargetListResult)res.getValue()).value(), ((TargetListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TargetInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<TargetListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TargetListResult)res.getValue()).value(), ((TargetListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ChaosManagementClien")
    public static interface TargetsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TargetInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @PathParam(value="targetName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TargetInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @PathParam(value="targetName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TargetInner>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @PathParam(value="targetName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") TargetInner var11, Context var12);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TargetInner> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @PathParam(value="targetName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") TargetInner var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @PathParam(value="targetName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @PathParam(value="targetName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TargetListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @QueryParam(value="continuationToken") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TargetListResult> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @QueryParam(value="continuationToken") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TargetListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TargetListResult> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

