/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.chaos.ChaosManager;
import com.azure.resourcemanager.chaos.fluent.OperationStatusesClient;
import com.azure.resourcemanager.chaos.fluent.models.OperationStatusInner;
import com.azure.resourcemanager.chaos.implementation.OperationStatusImpl;
import com.azure.resourcemanager.chaos.models.OperationStatus;
import com.azure.resourcemanager.chaos.models.OperationStatuses;

public final class OperationStatusesImpl
implements OperationStatuses {
    private static final ClientLogger LOGGER = new ClientLogger(OperationStatusesImpl.class);
    private final OperationStatusesClient innerClient;
    private final ChaosManager serviceManager;

    public OperationStatusesImpl(OperationStatusesClient innerClient, ChaosManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<OperationStatus> getWithResponse(String location, String operationId, Context context) {
        Response<OperationStatusInner> inner = this.serviceClient().getWithResponse(location, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationStatusImpl((OperationStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationStatus get(String location, String operationId) {
        OperationStatusInner inner = this.serviceClient().get(location, operationId);
        if (inner != null) {
            return new OperationStatusImpl(inner, this.manager());
        }
        return null;
    }

    private OperationStatusesClient serviceClient() {
        return this.innerClient;
    }

    private ChaosManager manager() {
        return this.serviceManager;
    }
}

