/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.chaos.ChaosManager;
import com.azure.resourcemanager.chaos.fluent.ExperimentsClient;
import com.azure.resourcemanager.chaos.fluent.models.ExperimentExecutionDetailsInner;
import com.azure.resourcemanager.chaos.fluent.models.ExperimentExecutionInner;
import com.azure.resourcemanager.chaos.fluent.models.ExperimentInner;
import com.azure.resourcemanager.chaos.implementation.ExperimentExecutionDetailsImpl;
import com.azure.resourcemanager.chaos.implementation.ExperimentExecutionImpl;
import com.azure.resourcemanager.chaos.implementation.ExperimentImpl;
import com.azure.resourcemanager.chaos.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.chaos.models.Experiment;
import com.azure.resourcemanager.chaos.models.ExperimentExecution;
import com.azure.resourcemanager.chaos.models.ExperimentExecutionDetails;
import com.azure.resourcemanager.chaos.models.Experiments;

public final class ExperimentsImpl
implements Experiments {
    private static final ClientLogger LOGGER = new ClientLogger(ExperimentsImpl.class);
    private final ExperimentsClient innerClient;
    private final ChaosManager serviceManager;

    public ExperimentsImpl(ExperimentsClient innerClient, ChaosManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Experiment> getByResourceGroupWithResponse(String resourceGroupName, String experimentName, Context context) {
        Response<ExperimentInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, experimentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ExperimentImpl((ExperimentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Experiment getByResourceGroup(String resourceGroupName, String experimentName) {
        ExperimentInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, experimentName);
        if (inner != null) {
            return new ExperimentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String experimentName) {
        this.serviceClient().delete(resourceGroupName, experimentName);
    }

    @Override
    public void delete(String resourceGroupName, String experimentName, Context context) {
        this.serviceClient().delete(resourceGroupName, experimentName, context);
    }

    @Override
    public PagedIterable<Experiment> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ExperimentInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ExperimentImpl((ExperimentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Experiment> listByResourceGroup(String resourceGroupName, Boolean running, String continuationToken, Context context) {
        PagedIterable<ExperimentInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, running, continuationToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ExperimentImpl((ExperimentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Experiment> list() {
        PagedIterable<ExperimentInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ExperimentImpl((ExperimentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Experiment> list(Boolean running, String continuationToken, Context context) {
        PagedIterable<ExperimentInner> inner = this.serviceClient().list(running, continuationToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ExperimentImpl((ExperimentInner)((Object)inner1), this.manager()));
    }

    @Override
    public void cancel(String resourceGroupName, String experimentName) {
        this.serviceClient().cancel(resourceGroupName, experimentName);
    }

    @Override
    public void cancel(String resourceGroupName, String experimentName, Context context) {
        this.serviceClient().cancel(resourceGroupName, experimentName, context);
    }

    @Override
    public void start(String resourceGroupName, String experimentName) {
        this.serviceClient().start(resourceGroupName, experimentName);
    }

    @Override
    public void start(String resourceGroupName, String experimentName, Context context) {
        this.serviceClient().start(resourceGroupName, experimentName, context);
    }

    @Override
    public Response<ExperimentExecution> getExecutionWithResponse(String resourceGroupName, String experimentName, String executionId, Context context) {
        Response<ExperimentExecutionInner> inner = this.serviceClient().getExecutionWithResponse(resourceGroupName, experimentName, executionId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ExperimentExecutionImpl((ExperimentExecutionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ExperimentExecution getExecution(String resourceGroupName, String experimentName, String executionId) {
        ExperimentExecutionInner inner = this.serviceClient().getExecution(resourceGroupName, experimentName, executionId);
        if (inner != null) {
            return new ExperimentExecutionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ExperimentExecution> listAllExecutions(String resourceGroupName, String experimentName) {
        PagedIterable<ExperimentExecutionInner> inner = this.serviceClient().listAllExecutions(resourceGroupName, experimentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ExperimentExecutionImpl((ExperimentExecutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ExperimentExecution> listAllExecutions(String resourceGroupName, String experimentName, Context context) {
        PagedIterable<ExperimentExecutionInner> inner = this.serviceClient().listAllExecutions(resourceGroupName, experimentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ExperimentExecutionImpl((ExperimentExecutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ExperimentExecutionDetails> executionDetailsWithResponse(String resourceGroupName, String experimentName, String executionId, Context context) {
        Response<ExperimentExecutionDetailsInner> inner = this.serviceClient().executionDetailsWithResponse(resourceGroupName, experimentName, executionId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ExperimentExecutionDetailsImpl((ExperimentExecutionDetailsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ExperimentExecutionDetails executionDetails(String resourceGroupName, String experimentName, String executionId) {
        ExperimentExecutionDetailsInner inner = this.serviceClient().executionDetails(resourceGroupName, experimentName, executionId);
        if (inner != null) {
            return new ExperimentExecutionDetailsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Experiment getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String experimentName = ResourceManagerUtils.getValueFromIdByName(id, "experiments");
        if (experimentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'experiments'.", id)));
        }
        return (Experiment)this.getByResourceGroupWithResponse(resourceGroupName, experimentName, Context.NONE).getValue();
    }

    @Override
    public Response<Experiment> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String experimentName = ResourceManagerUtils.getValueFromIdByName(id, "experiments");
        if (experimentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'experiments'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, experimentName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String experimentName = ResourceManagerUtils.getValueFromIdByName(id, "experiments");
        if (experimentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'experiments'.", id)));
        }
        this.delete(resourceGroupName, experimentName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String experimentName = ResourceManagerUtils.getValueFromIdByName(id, "experiments");
        if (experimentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'experiments'.", id)));
        }
        this.delete(resourceGroupName, experimentName, context);
    }

    private ExperimentsClient serviceClient() {
        return this.innerClient;
    }

    private ChaosManager manager() {
        return this.serviceManager;
    }

    @Override
    public ExperimentImpl define(String name) {
        return new ExperimentImpl(name, this.manager());
    }
}

