/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.chaos.ChaosManager;
import com.azure.resourcemanager.chaos.fluent.models.ExperimentInner;
import com.azure.resourcemanager.chaos.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.chaos.models.ChaosExperimentStep;
import com.azure.resourcemanager.chaos.models.ChaosTargetSelector;
import com.azure.resourcemanager.chaos.models.Experiment;
import com.azure.resourcemanager.chaos.models.ExperimentUpdate;
import com.azure.resourcemanager.chaos.models.ProvisioningState;
import com.azure.resourcemanager.chaos.models.ResourceIdentity;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ExperimentImpl
implements Experiment,
Experiment.Definition,
Experiment.Update {
    private ExperimentInner innerObject;
    private final ChaosManager serviceManager;
    private String resourceGroupName;
    private String experimentName;
    private ExperimentUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ResourceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public List<ChaosExperimentStep> steps() {
        List<ChaosExperimentStep> inner = this.innerModel().steps();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ChaosTargetSelector> selectors() {
        List<ChaosTargetSelector> inner = this.innerModel().selectors();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ExperimentInner innerModel() {
        return this.innerObject;
    }

    private ChaosManager manager() {
        return this.serviceManager;
    }

    @Override
    public ExperimentImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Experiment create() {
        this.innerObject = this.serviceManager.serviceClient().getExperiments().createOrUpdate(this.resourceGroupName, this.experimentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Experiment create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getExperiments().createOrUpdate(this.resourceGroupName, this.experimentName, this.innerModel(), context);
        return this;
    }

    ExperimentImpl(String name, ChaosManager serviceManager) {
        this.innerObject = new ExperimentInner();
        this.serviceManager = serviceManager;
        this.experimentName = name;
    }

    @Override
    public ExperimentImpl update() {
        this.updateProperties = new ExperimentUpdate();
        return this;
    }

    @Override
    public Experiment apply() {
        this.innerObject = this.serviceManager.serviceClient().getExperiments().update(this.resourceGroupName, this.experimentName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public Experiment apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getExperiments().update(this.resourceGroupName, this.experimentName, this.updateProperties, context);
        return this;
    }

    ExperimentImpl(ExperimentInner innerObject, ChaosManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.experimentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "experiments");
    }

    @Override
    public Experiment refresh() {
        this.innerObject = (ExperimentInner)((Object)this.serviceManager.serviceClient().getExperiments().getByResourceGroupWithResponse(this.resourceGroupName, this.experimentName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Experiment refresh(Context context) {
        this.innerObject = (ExperimentInner)((Object)this.serviceManager.serviceClient().getExperiments().getByResourceGroupWithResponse(this.resourceGroupName, this.experimentName, context).getValue());
        return this;
    }

    @Override
    public void cancel() {
        this.serviceManager.experiments().cancel(this.resourceGroupName, this.experimentName);
    }

    @Override
    public void cancel(Context context) {
        this.serviceManager.experiments().cancel(this.resourceGroupName, this.experimentName, context);
    }

    @Override
    public void start() {
        this.serviceManager.experiments().start(this.resourceGroupName, this.experimentName);
    }

    @Override
    public void start(Context context) {
        this.serviceManager.experiments().start(this.resourceGroupName, this.experimentName, context);
    }

    @Override
    public ExperimentImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ExperimentImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ExperimentImpl withSteps(List<ChaosExperimentStep> steps) {
        this.innerModel().withSteps(steps);
        return this;
    }

    @Override
    public ExperimentImpl withSelectors(List<ChaosTargetSelector> selectors) {
        this.innerModel().withSelectors(selectors);
        return this;
    }

    @Override
    public ExperimentImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public ExperimentImpl withIdentity(ResourceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateProperties.withIdentity(identity);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

