/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.chaos.ChaosManager;
import com.azure.resourcemanager.chaos.fluent.CapabilityTypesClient;
import com.azure.resourcemanager.chaos.fluent.models.CapabilityTypeInner;
import com.azure.resourcemanager.chaos.implementation.CapabilityTypeImpl;
import com.azure.resourcemanager.chaos.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.chaos.models.CapabilityType;
import com.azure.resourcemanager.chaos.models.CapabilityTypes;

public final class CapabilityTypesImpl
implements CapabilityTypes {
    private static final ClientLogger LOGGER = new ClientLogger(CapabilityTypesImpl.class);
    private final CapabilityTypesClient innerClient;
    private final ChaosManager serviceManager;

    public CapabilityTypesImpl(CapabilityTypesClient innerClient, ChaosManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CapabilityType> getWithResponse(String location, String targetTypeName, String capabilityTypeName, Context context) {
        Response<CapabilityTypeInner> inner = this.serviceClient().getWithResponse(location, targetTypeName, capabilityTypeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CapabilityTypeImpl((CapabilityTypeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public CapabilityType get(String location, String targetTypeName, String capabilityTypeName) {
        CapabilityTypeInner inner = this.serviceClient().get(location, targetTypeName, capabilityTypeName);
        if (inner != null) {
            return new CapabilityTypeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<CapabilityType> list(String location, String targetTypeName) {
        PagedIterable<CapabilityTypeInner> inner = this.serviceClient().list(location, targetTypeName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CapabilityTypeImpl((CapabilityTypeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CapabilityType> list(String location, String targetTypeName, String continuationToken, Context context) {
        PagedIterable<CapabilityTypeInner> inner = this.serviceClient().list(location, targetTypeName, continuationToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CapabilityTypeImpl((CapabilityTypeInner)((Object)inner1), this.manager()));
    }

    private CapabilityTypesClient serviceClient() {
        return this.innerClient;
    }

    private ChaosManager manager() {
        return this.serviceManager;
    }
}

