/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.chaos.ChaosManager;
import com.azure.resourcemanager.chaos.fluent.CapabilitiesClient;
import com.azure.resourcemanager.chaos.fluent.models.CapabilityInner;
import com.azure.resourcemanager.chaos.implementation.CapabilityImpl;
import com.azure.resourcemanager.chaos.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.chaos.models.Capabilities;
import com.azure.resourcemanager.chaos.models.Capability;

public final class CapabilitiesImpl
implements Capabilities {
    private static final ClientLogger LOGGER = new ClientLogger(CapabilitiesImpl.class);
    private final CapabilitiesClient innerClient;
    private final ChaosManager serviceManager;

    public CapabilitiesImpl(CapabilitiesClient innerClient, ChaosManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Capability> getWithResponse(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName, Context context) {
        Response<CapabilityInner> inner = this.serviceClient().getWithResponse(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CapabilityImpl((CapabilityInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Capability get(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName) {
        CapabilityInner inner = this.serviceClient().get(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName);
        if (inner != null) {
            return new CapabilityImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Capability> createOrUpdateWithResponse(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName, CapabilityInner resource, Context context) {
        Response<CapabilityInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, resource, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CapabilityImpl((CapabilityInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Capability createOrUpdate(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName, CapabilityInner resource) {
        CapabilityInner inner = this.serviceClient().createOrUpdate(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, resource);
        if (inner != null) {
            return new CapabilityImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, context);
    }

    @Override
    public void delete(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName) {
        this.serviceClient().delete(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName);
    }

    @Override
    public PagedIterable<Capability> list(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName) {
        PagedIterable<CapabilityInner> inner = this.serviceClient().list(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CapabilityImpl((CapabilityInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Capability> list(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String continuationToken, Context context) {
        PagedIterable<CapabilityInner> inner = this.serviceClient().list(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, continuationToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CapabilityImpl((CapabilityInner)((Object)inner1), this.manager()));
    }

    private CapabilitiesClient serviceClient() {
        return this.innerClient;
    }

    private ChaosManager manager() {
        return this.serviceManager;
    }
}

