/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.chaos.fluent.CapabilitiesClient;
import com.azure.resourcemanager.chaos.fluent.models.CapabilityInner;
import com.azure.resourcemanager.chaos.implementation.ChaosManagementClientImpl;
import com.azure.resourcemanager.chaos.implementation.models.CapabilityListResult;
import reactor.core.publisher.Mono;

public final class CapabilitiesClientImpl
implements CapabilitiesClient {
    private final CapabilitiesService service;
    private final ChaosManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(CapabilitiesClientImpl.class);

    CapabilitiesClientImpl(ChaosManagementClientImpl client) {
        this.service = (CapabilitiesService)RestProxy.create(CapabilitiesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CapabilityInner>> getWithResponseAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (capabilityName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capabilityName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CapabilityInner> getAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName) {
        return this.getWithResponseAsync(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CapabilityInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CapabilityInner> getWithResponse(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (capabilityName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter capabilityName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CapabilityInner get(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName) {
        return (CapabilityInner)((Object)this.getWithResponse(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CapabilityInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName, CapabilityInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (capabilityName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capabilityName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, "application/json", "application/json", resource, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CapabilityInner> createOrUpdateAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName, CapabilityInner resource) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, resource).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CapabilityInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CapabilityInner> createOrUpdateWithResponse(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName, CapabilityInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (capabilityName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter capabilityName is required and cannot be null."));
        }
        if (resource == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, "application/json", "application/json", resource, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CapabilityInner createOrUpdate(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName, CapabilityInner resource) {
        return (CapabilityInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, resource, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (capabilityName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capabilityName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName) {
        return this.deleteWithResponseAsync(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        if (capabilityName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter capabilityName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String capabilityName) {
        this.deleteWithResponse(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapabilityInner>> listSinglePageAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String continuationToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, continuationToken, targetName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapabilityListResult)res.getValue()).value(), ((CapabilityListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CapabilityInner> listAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String continuationToken) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, continuationToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CapabilityInner> listAsync(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName) {
        String continuationToken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, continuationToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CapabilityInner> listSinglePage(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String continuationToken) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CapabilityListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, continuationToken, targetName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapabilityListResult)res.getValue()).value(), ((CapabilityListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CapabilityInner> listSinglePage(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String continuationToken, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parentProviderNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentProviderNamespace is required and cannot be null."));
        }
        if (parentResourceType == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceType is required and cannot be null."));
        }
        if (parentResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parentResourceName is required and cannot be null."));
        }
        if (targetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CapabilityListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, continuationToken, targetName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapabilityListResult)res.getValue()).value(), ((CapabilityListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CapabilityInner> list(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName) {
        String continuationToken = null;
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, continuationToken), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CapabilityInner> list(String resourceGroupName, String parentProviderNamespace, String parentResourceType, String parentResourceName, String targetName, String continuationToken, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, continuationToken, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapabilityInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapabilityListResult)res.getValue()).value(), ((CapabilityListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CapabilityInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CapabilityListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapabilityListResult)res.getValue()).value(), ((CapabilityListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CapabilityInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CapabilityListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapabilityListResult)res.getValue()).value(), ((CapabilityListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ChaosManagementClien")
    public static interface CapabilitiesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}/capabilities/{capabilityName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CapabilityInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @PathParam(value="targetName") String var8, @PathParam(value="capabilityName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}/capabilities/{capabilityName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CapabilityInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @PathParam(value="targetName") String var8, @PathParam(value="capabilityName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}/capabilities/{capabilityName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CapabilityInner>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @PathParam(value="targetName") String var8, @PathParam(value="capabilityName") String var9, @HeaderParam(value="Content-Type") String var10, @HeaderParam(value="Accept") String var11, @BodyParam(value="application/json") CapabilityInner var12, Context var13);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}/capabilities/{capabilityName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CapabilityInner> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @PathParam(value="targetName") String var8, @PathParam(value="capabilityName") String var9, @HeaderParam(value="Content-Type") String var10, @HeaderParam(value="Accept") String var11, @BodyParam(value="application/json") CapabilityInner var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}/capabilities/{capabilityName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @PathParam(value="targetName") String var8, @PathParam(value="capabilityName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}/capabilities/{capabilityName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @PathParam(value="targetName") String var8, @PathParam(value="capabilityName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}/capabilities")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CapabilityListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @QueryParam(value="continuationToken") String var8, @PathParam(value="targetName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}/capabilities")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CapabilityListResult> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="parentProviderNamespace") String var5, @PathParam(value="parentResourceType") String var6, @PathParam(value="parentResourceName") String var7, @QueryParam(value="continuationToken") String var8, @PathParam(value="targetName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CapabilityListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CapabilityListResult> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

