/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class TargetInner
extends ProxyResource {
    private Map<String, BinaryData> properties;
    private String location;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(TargetInner.class);

    public Map<String, BinaryData> properties() {
        return this.properties;
    }

    public TargetInner withProperties(Map<String, BinaryData> properties) {
        this.properties = properties;
        return this;
    }

    public String location() {
        return this.location;
    }

    public TargetInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model TargetInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static TargetInner fromJson(JsonReader jsonReader) throws IOException {
        return (TargetInner)((Object)jsonReader.readObject(reader -> {
            TargetInner deserializedTargetInner = new TargetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTargetInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTargetInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTargetInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedTargetInner.properties = properties = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedTargetInner.location = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedTargetInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetInner;
        }));
    }
}

