/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ChaosExperimentStep;
import com.azure.resourcemanager.chaos.models.ChaosTargetSelector;
import com.azure.resourcemanager.chaos.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ExperimentProperties
implements JsonSerializable<ExperimentProperties> {
    private ProvisioningState provisioningState;
    private List<ChaosExperimentStep> steps;
    private List<ChaosTargetSelector> selectors;
    private static final ClientLogger LOGGER = new ClientLogger(ExperimentProperties.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<ChaosExperimentStep> steps() {
        return this.steps;
    }

    public ExperimentProperties withSteps(List<ChaosExperimentStep> steps) {
        this.steps = steps;
        return this;
    }

    public List<ChaosTargetSelector> selectors() {
        return this.selectors;
    }

    public ExperimentProperties withSelectors(List<ChaosTargetSelector> selectors) {
        this.selectors = selectors;
        return this;
    }

    public void validate() {
        if (this.steps() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property steps in model ExperimentProperties"));
        }
        this.steps().forEach(e -> e.validate());
        if (this.selectors() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectors in model ExperimentProperties"));
        }
        this.selectors().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("steps", this.steps, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("selectors", this.selectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExperimentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExperimentProperties)jsonReader.readObject(reader -> {
            ExperimentProperties deserializedExperimentProperties = new ExperimentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("steps".equals(fieldName)) {
                    List steps;
                    deserializedExperimentProperties.steps = steps = reader.readArray(reader1 -> ChaosExperimentStep.fromJson(reader1));
                    continue;
                }
                if ("selectors".equals(fieldName)) {
                    List selectors;
                    deserializedExperimentProperties.selectors = selectors = reader.readArray(reader1 -> ChaosTargetSelector.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedExperimentProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExperimentProperties;
        });
    }
}

