/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.fluent.models.ExperimentProperties;
import com.azure.resourcemanager.chaos.models.ChaosExperimentStep;
import com.azure.resourcemanager.chaos.models.ChaosTargetSelector;
import com.azure.resourcemanager.chaos.models.ProvisioningState;
import com.azure.resourcemanager.chaos.models.ResourceIdentity;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ExperimentInner
extends Resource {
    private ResourceIdentity identity;
    private ExperimentProperties innerProperties = new ExperimentProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ExperimentInner.class);

    public ResourceIdentity identity() {
        return this.identity;
    }

    public ExperimentInner withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ExperimentProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ExperimentInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ExperimentInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<ChaosExperimentStep> steps() {
        return this.innerProperties() == null ? null : this.innerProperties().steps();
    }

    public ExperimentInner withSteps(List<ChaosExperimentStep> steps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExperimentProperties();
        }
        this.innerProperties().withSteps(steps);
        return this;
    }

    public List<ChaosTargetSelector> selectors() {
        return this.innerProperties() == null ? null : this.innerProperties().selectors();
    }

    public ExperimentInner withSelectors(List<ChaosTargetSelector> selectors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExperimentProperties();
        }
        this.innerProperties().withSelectors(selectors);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ExperimentInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static ExperimentInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExperimentInner)((Object)jsonReader.readObject(reader -> {
            ExperimentInner deserializedExperimentInner = new ExperimentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExperimentInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedExperimentInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExperimentInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedExperimentInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedExperimentInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExperimentInner.innerProperties = ExperimentProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedExperimentInner.identity = ResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedExperimentInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExperimentInner;
        }));
    }
}

