/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.fluent.models.ExperimentExecutionProperties;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ExperimentExecutionInner
extends ProxyResource {
    private ExperimentExecutionProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ExperimentExecutionInner() {
    }

    private ExperimentExecutionProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public OffsetDateTime startedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().startedAt();
    }

    public OffsetDateTime stoppedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().stoppedAt();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ExperimentExecutionInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExperimentExecutionInner)((Object)jsonReader.readObject(reader -> {
            ExperimentExecutionInner deserializedExperimentExecutionInner = new ExperimentExecutionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExperimentExecutionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedExperimentExecutionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExperimentExecutionInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExperimentExecutionInner.innerProperties = ExperimentExecutionProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedExperimentExecutionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExperimentExecutionInner;
        }));
    }
}

