/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ExperimentExecutionDetailsPropertiesRunInformation;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ExperimentExecutionDetailsProperties
implements JsonSerializable<ExperimentExecutionDetailsProperties> {
    private String status;
    private OffsetDateTime startedAt;
    private OffsetDateTime stoppedAt;
    private String failureReason;
    private OffsetDateTime lastActionAt;
    private ExperimentExecutionDetailsPropertiesRunInformation runInformation;

    private ExperimentExecutionDetailsProperties() {
    }

    public String status() {
        return this.status;
    }

    public OffsetDateTime startedAt() {
        return this.startedAt;
    }

    public OffsetDateTime stoppedAt() {
        return this.stoppedAt;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public OffsetDateTime lastActionAt() {
        return this.lastActionAt;
    }

    public ExperimentExecutionDetailsPropertiesRunInformation runInformation() {
        return this.runInformation;
    }

    public void validate() {
        if (this.runInformation() != null) {
            this.runInformation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ExperimentExecutionDetailsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExperimentExecutionDetailsProperties)jsonReader.readObject(reader -> {
            ExperimentExecutionDetailsProperties deserializedExperimentExecutionDetailsProperties = new ExperimentExecutionDetailsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedExperimentExecutionDetailsProperties.status = reader.getString();
                    continue;
                }
                if ("startedAt".equals(fieldName)) {
                    deserializedExperimentExecutionDetailsProperties.startedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("stoppedAt".equals(fieldName)) {
                    deserializedExperimentExecutionDetailsProperties.stoppedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("failureReason".equals(fieldName)) {
                    deserializedExperimentExecutionDetailsProperties.failureReason = reader.getString();
                    continue;
                }
                if ("lastActionAt".equals(fieldName)) {
                    deserializedExperimentExecutionDetailsProperties.lastActionAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("runInformation".equals(fieldName)) {
                    deserializedExperimentExecutionDetailsProperties.runInformation = ExperimentExecutionDetailsPropertiesRunInformation.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExperimentExecutionDetailsProperties;
        });
    }
}

