/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class LoadBalancingSettingsParameters
implements JsonSerializable<LoadBalancingSettingsParameters> {
    private Integer sampleSize;
    private Integer successfulSamplesRequired;
    private Integer additionalLatencyInMilliseconds;

    public Integer sampleSize() {
        return this.sampleSize;
    }

    public LoadBalancingSettingsParameters withSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
        return this;
    }

    public Integer successfulSamplesRequired() {
        return this.successfulSamplesRequired;
    }

    public LoadBalancingSettingsParameters withSuccessfulSamplesRequired(Integer successfulSamplesRequired) {
        this.successfulSamplesRequired = successfulSamplesRequired;
        return this;
    }

    public Integer additionalLatencyInMilliseconds() {
        return this.additionalLatencyInMilliseconds;
    }

    public LoadBalancingSettingsParameters withAdditionalLatencyInMilliseconds(Integer additionalLatencyInMilliseconds) {
        this.additionalLatencyInMilliseconds = additionalLatencyInMilliseconds;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("sampleSize", (Number)this.sampleSize);
        jsonWriter.writeNumberField("successfulSamplesRequired", (Number)this.successfulSamplesRequired);
        jsonWriter.writeNumberField("additionalLatencyInMilliseconds", (Number)this.additionalLatencyInMilliseconds);
        return jsonWriter.writeEndObject();
    }

    public static LoadBalancingSettingsParameters fromJson(JsonReader jsonReader) throws IOException {
        return (LoadBalancingSettingsParameters)jsonReader.readObject(reader -> {
            LoadBalancingSettingsParameters deserializedLoadBalancingSettingsParameters = new LoadBalancingSettingsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sampleSize".equals(fieldName)) {
                    deserializedLoadBalancingSettingsParameters.sampleSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("successfulSamplesRequired".equals(fieldName)) {
                    deserializedLoadBalancingSettingsParameters.successfulSamplesRequired = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("additionalLatencyInMilliseconds".equals(fieldName)) {
                    deserializedLoadBalancingSettingsParameters.additionalLatencyInMilliseconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoadBalancingSettingsParameters;
        });
    }
}

