/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.AfdDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.io.IOException;

public class AfdDomainUpdatePropertiesParameters
implements JsonSerializable<AfdDomainUpdatePropertiesParameters> {
    private String profileName;
    private AfdDomainHttpsParameters tlsSettings;
    private ResourceReference azureDnsZone;
    private ResourceReference preValidatedCustomDomainResourceId;

    public String profileName() {
        return this.profileName;
    }

    AfdDomainUpdatePropertiesParameters withProfileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    public AfdDomainHttpsParameters tlsSettings() {
        return this.tlsSettings;
    }

    public AfdDomainUpdatePropertiesParameters withTlsSettings(AfdDomainHttpsParameters tlsSettings) {
        this.tlsSettings = tlsSettings;
        return this;
    }

    public ResourceReference azureDnsZone() {
        return this.azureDnsZone;
    }

    public AfdDomainUpdatePropertiesParameters withAzureDnsZone(ResourceReference azureDnsZone) {
        this.azureDnsZone = azureDnsZone;
        return this;
    }

    public ResourceReference preValidatedCustomDomainResourceId() {
        return this.preValidatedCustomDomainResourceId;
    }

    public AfdDomainUpdatePropertiesParameters withPreValidatedCustomDomainResourceId(ResourceReference preValidatedCustomDomainResourceId) {
        this.preValidatedCustomDomainResourceId = preValidatedCustomDomainResourceId;
        return this;
    }

    public void validate() {
        if (this.tlsSettings() != null) {
            this.tlsSettings().validate();
        }
        if (this.azureDnsZone() != null) {
            this.azureDnsZone().validate();
        }
        if (this.preValidatedCustomDomainResourceId() != null) {
            this.preValidatedCustomDomainResourceId().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("tlsSettings", (JsonSerializable)this.tlsSettings);
        jsonWriter.writeJsonField("azureDnsZone", (JsonSerializable)this.azureDnsZone);
        jsonWriter.writeJsonField("preValidatedCustomDomainResourceId", (JsonSerializable)this.preValidatedCustomDomainResourceId);
        return jsonWriter.writeEndObject();
    }

    public static AfdDomainUpdatePropertiesParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AfdDomainUpdatePropertiesParameters)jsonReader.readObject(reader -> {
            AfdDomainUpdatePropertiesParameters deserializedAfdDomainUpdatePropertiesParameters = new AfdDomainUpdatePropertiesParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("profileName".equals(fieldName)) {
                    deserializedAfdDomainUpdatePropertiesParameters.profileName = reader.getString();
                    continue;
                }
                if ("tlsSettings".equals(fieldName)) {
                    deserializedAfdDomainUpdatePropertiesParameters.tlsSettings = AfdDomainHttpsParameters.fromJson(reader);
                    continue;
                }
                if ("azureDnsZone".equals(fieldName)) {
                    deserializedAfdDomainUpdatePropertiesParameters.azureDnsZone = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("preValidatedCustomDomainResourceId".equals(fieldName)) {
                    deserializedAfdDomainUpdatePropertiesParameters.preValidatedCustomDomainResourceId = ResourceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAfdDomainUpdatePropertiesParameters;
        });
    }
}

