/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.IsDeviceMatchConditionParametersMatchValuesItem;
import com.azure.resourcemanager.cdn.models.IsDeviceOperator;
import com.azure.resourcemanager.cdn.models.Transform;
import java.io.IOException;
import java.util.List;

public final class IsDeviceMatchConditionParameters
implements JsonSerializable<IsDeviceMatchConditionParameters> {
    private String typeName = "DeliveryRuleIsDeviceConditionParameters";
    private IsDeviceOperator operator;
    private Boolean negateCondition;
    private List<IsDeviceMatchConditionParametersMatchValuesItem> matchValues;
    private List<Transform> transforms;
    private static final ClientLogger LOGGER = new ClientLogger(IsDeviceMatchConditionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public IsDeviceMatchConditionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public IsDeviceOperator operator() {
        return this.operator;
    }

    public IsDeviceMatchConditionParameters withOperator(IsDeviceOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public IsDeviceMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<IsDeviceMatchConditionParametersMatchValuesItem> matchValues() {
        return this.matchValues;
    }

    public IsDeviceMatchConditionParameters withMatchValues(List<IsDeviceMatchConditionParametersMatchValuesItem> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public List<Transform> transforms() {
        return this.transforms;
    }

    public IsDeviceMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model IsDeviceMatchConditionParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeBooleanField("negateCondition", this.negateCondition);
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static IsDeviceMatchConditionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (IsDeviceMatchConditionParameters)jsonReader.readObject(reader -> {
            IsDeviceMatchConditionParameters deserializedIsDeviceMatchConditionParameters = new IsDeviceMatchConditionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operator".equals(fieldName)) {
                    deserializedIsDeviceMatchConditionParameters.operator = IsDeviceOperator.fromString(reader.getString());
                    continue;
                }
                if ("negateCondition".equals(fieldName)) {
                    deserializedIsDeviceMatchConditionParameters.negateCondition = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("matchValues".equals(fieldName)) {
                    List matchValues;
                    deserializedIsDeviceMatchConditionParameters.matchValues = matchValues = reader.readArray(reader1 -> IsDeviceMatchConditionParametersMatchValuesItem.fromString(reader1.getString()));
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List transforms;
                    deserializedIsDeviceMatchConditionParameters.transforms = transforms = reader.readArray(reader1 -> Transform.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIsDeviceMatchConditionParameters;
        });
    }
}

