/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.GeoFilterActions;
import java.io.IOException;
import java.util.List;

public final class GeoFilter
implements JsonSerializable<GeoFilter> {
    private String relativePath;
    private GeoFilterActions action;
    private List<String> countryCodes;
    private static final ClientLogger LOGGER = new ClientLogger(GeoFilter.class);

    public String relativePath() {
        return this.relativePath;
    }

    public GeoFilter withRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    public GeoFilterActions action() {
        return this.action;
    }

    public GeoFilter withAction(GeoFilterActions action) {
        this.action = action;
        return this;
    }

    public List<String> countryCodes() {
        return this.countryCodes;
    }

    public GeoFilter withCountryCodes(List<String> countryCodes) {
        this.countryCodes = countryCodes;
        return this;
    }

    public void validate() {
        if (this.relativePath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property relativePath in model GeoFilter"));
        }
        if (this.action() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property action in model GeoFilter"));
        }
        if (this.countryCodes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property countryCodes in model GeoFilter"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("relativePath", this.relativePath);
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeArrayField("countryCodes", this.countryCodes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static GeoFilter fromJson(JsonReader jsonReader) throws IOException {
        return (GeoFilter)jsonReader.readObject(reader -> {
            GeoFilter deserializedGeoFilter = new GeoFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("relativePath".equals(fieldName)) {
                    deserializedGeoFilter.relativePath = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedGeoFilter.action = GeoFilterActions.fromString(reader.getString());
                    continue;
                }
                if ("countryCodes".equals(fieldName)) {
                    List countryCodes;
                    deserializedGeoFilter.countryCodes = countryCodes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGeoFilter;
        });
    }
}

