/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.azure.resourcemanager.cdn.models.MatchVariable;
import com.azure.resourcemanager.cdn.models.ServerPortMatchConditionParameters;
import java.io.IOException;

public final class DeliveryRuleServerPortCondition
extends DeliveryRuleCondition {
    private MatchVariable name = MatchVariable.SERVER_PORT;
    private ServerPortMatchConditionParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRuleServerPortCondition.class);

    @Override
    public MatchVariable name() {
        return this.name;
    }

    public ServerPortMatchConditionParameters parameters() {
        return this.parameters;
    }

    public DeliveryRuleServerPortCondition withParameters(ServerPortMatchConditionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parameters in model DeliveryRuleServerPortCondition"));
        }
        this.parameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static DeliveryRuleServerPortCondition fromJson(JsonReader jsonReader) throws IOException {
        return (DeliveryRuleServerPortCondition)jsonReader.readObject(reader -> {
            DeliveryRuleServerPortCondition deserializedDeliveryRuleServerPortCondition = new DeliveryRuleServerPortCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    deserializedDeliveryRuleServerPortCondition.parameters = ServerPortMatchConditionParameters.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeliveryRuleServerPortCondition.name = MatchVariable.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryRuleServerPortCondition;
        });
    }
}

