/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CanMigrateDefaultSku;
import com.azure.resourcemanager.cdn.models.MigrationErrorType;
import java.io.IOException;
import java.util.List;

public final class CanMigrateProperties
implements JsonSerializable<CanMigrateProperties> {
    private Boolean canMigrate;
    private CanMigrateDefaultSku defaultSku;
    private List<MigrationErrorType> errors;

    public Boolean canMigrate() {
        return this.canMigrate;
    }

    public CanMigrateDefaultSku defaultSku() {
        return this.defaultSku;
    }

    public List<MigrationErrorType> errors() {
        return this.errors;
    }

    public CanMigrateProperties withErrors(List<MigrationErrorType> errors) {
        this.errors = errors;
        return this;
    }

    public void validate() {
        if (this.errors() != null) {
            this.errors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CanMigrateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CanMigrateProperties)jsonReader.readObject(reader -> {
            CanMigrateProperties deserializedCanMigrateProperties = new CanMigrateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("canMigrate".equals(fieldName)) {
                    deserializedCanMigrateProperties.canMigrate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultSku".equals(fieldName)) {
                    deserializedCanMigrateProperties.defaultSku = CanMigrateDefaultSku.fromString(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedCanMigrateProperties.errors = errors = reader.readArray(reader1 -> MigrationErrorType.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCanMigrateProperties;
        });
    }
}

