/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class UrlRewriteActionParameters
implements JsonSerializable<UrlRewriteActionParameters> {
    private String typeName = "DeliveryRuleUrlRewriteActionParameters";
    private String sourcePattern;
    private String destination;
    private Boolean preserveUnmatchedPath;
    private static final ClientLogger LOGGER = new ClientLogger(UrlRewriteActionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public UrlRewriteActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String sourcePattern() {
        return this.sourcePattern;
    }

    public UrlRewriteActionParameters withSourcePattern(String sourcePattern) {
        this.sourcePattern = sourcePattern;
        return this;
    }

    public String destination() {
        return this.destination;
    }

    public UrlRewriteActionParameters withDestination(String destination) {
        this.destination = destination;
        return this;
    }

    public Boolean preserveUnmatchedPath() {
        return this.preserveUnmatchedPath;
    }

    public UrlRewriteActionParameters withPreserveUnmatchedPath(Boolean preserveUnmatchedPath) {
        this.preserveUnmatchedPath = preserveUnmatchedPath;
        return this;
    }

    public void validate() {
        if (this.sourcePattern() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourcePattern in model UrlRewriteActionParameters"));
        }
        if (this.destination() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destination in model UrlRewriteActionParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("sourcePattern", this.sourcePattern);
        jsonWriter.writeStringField("destination", this.destination);
        jsonWriter.writeBooleanField("preserveUnmatchedPath", this.preserveUnmatchedPath);
        return jsonWriter.writeEndObject();
    }

    public static UrlRewriteActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (UrlRewriteActionParameters)jsonReader.readObject(reader -> {
            UrlRewriteActionParameters deserializedUrlRewriteActionParameters = new UrlRewriteActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourcePattern".equals(fieldName)) {
                    deserializedUrlRewriteActionParameters.sourcePattern = reader.getString();
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedUrlRewriteActionParameters.destination = reader.getString();
                    continue;
                }
                if ("preserveUnmatchedPath".equals(fieldName)) {
                    deserializedUrlRewriteActionParameters.preserveUnmatchedPath = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUrlRewriteActionParameters;
        });
    }
}

