/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CustomRule;
import java.io.IOException;
import java.util.List;

public final class CustomRuleList
implements JsonSerializable<CustomRuleList> {
    private List<CustomRule> rules;

    public List<CustomRule> rules() {
        return this.rules;
    }

    public CustomRuleList withRules(List<CustomRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CustomRuleList fromJson(JsonReader jsonReader) throws IOException {
        return (CustomRuleList)jsonReader.readObject(reader -> {
            CustomRuleList deserializedCustomRuleList = new CustomRuleList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedCustomRuleList.rules = rules = reader.readArray(reader1 -> CustomRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomRuleList;
        });
    }
}

