/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionData;
import com.azure.resourcemanager.carbonoptimization.models.ResponseDataTypeEnum;
import java.io.IOException;

public final class CarbonEmissionMonthlySummaryData
extends CarbonEmissionData {
    private ResponseDataTypeEnum dataType = ResponseDataTypeEnum.MONTHLY_SUMMARY_DATA;
    private String date;
    private double carbonIntensity;
    private static final ClientLogger LOGGER = new ClientLogger(CarbonEmissionMonthlySummaryData.class);

    private CarbonEmissionMonthlySummaryData() {
    }

    @Override
    public ResponseDataTypeEnum dataType() {
        return this.dataType;
    }

    public String date() {
        return this.date;
    }

    public double carbonIntensity() {
        return this.carbonIntensity;
    }

    @Override
    public void validate() {
        if (this.date() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property date in model CarbonEmissionMonthlySummaryData"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("latestMonthEmissions", this.latestMonthEmissions());
        jsonWriter.writeDoubleField("previousMonthEmissions", this.previousMonthEmissions());
        jsonWriter.writeNumberField("monthOverMonthEmissionsChangeRatio", (Number)this.monthOverMonthEmissionsChangeRatio());
        jsonWriter.writeNumberField("monthlyEmissionsChangeValue", (Number)this.monthlyEmissionsChangeValue());
        jsonWriter.writeStringField("date", this.date);
        jsonWriter.writeDoubleField("carbonIntensity", this.carbonIntensity);
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        return jsonWriter.writeEndObject();
    }

    public static CarbonEmissionMonthlySummaryData fromJson(JsonReader jsonReader) throws IOException {
        return (CarbonEmissionMonthlySummaryData)jsonReader.readObject(reader -> {
            CarbonEmissionMonthlySummaryData deserializedCarbonEmissionMonthlySummaryData = new CarbonEmissionMonthlySummaryData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("latestMonthEmissions".equals(fieldName)) {
                    deserializedCarbonEmissionMonthlySummaryData.withLatestMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("previousMonthEmissions".equals(fieldName)) {
                    deserializedCarbonEmissionMonthlySummaryData.withPreviousMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("monthOverMonthEmissionsChangeRatio".equals(fieldName)) {
                    deserializedCarbonEmissionMonthlySummaryData.withMonthOverMonthEmissionsChangeRatio((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("monthlyEmissionsChangeValue".equals(fieldName)) {
                    deserializedCarbonEmissionMonthlySummaryData.withMonthlyEmissionsChangeValue((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("date".equals(fieldName)) {
                    deserializedCarbonEmissionMonthlySummaryData.date = reader.getString();
                    continue;
                }
                if ("carbonIntensity".equals(fieldName)) {
                    deserializedCarbonEmissionMonthlySummaryData.carbonIntensity = reader.getDouble();
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    deserializedCarbonEmissionMonthlySummaryData.dataType = ResponseDataTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCarbonEmissionMonthlySummaryData;
        });
    }
}

