/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.carbonoptimization.implementation.CarbonOptimizationManagementClientImpl;
import java.time.Duration;

@ServiceClientBuilder(serviceClients={CarbonOptimizationManagementClientImpl.class})
public final class CarbonOptimizationManagementClientBuilder {
    private String endpoint;
    private AzureEnvironment environment;
    private HttpPipeline pipeline;
    private Duration defaultPollInterval;
    private SerializerAdapter serializerAdapter;

    public CarbonOptimizationManagementClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public CarbonOptimizationManagementClientBuilder environment(AzureEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public CarbonOptimizationManagementClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public CarbonOptimizationManagementClientBuilder defaultPollInterval(Duration defaultPollInterval) {
        this.defaultPollInterval = defaultPollInterval;
        return this;
    }

    public CarbonOptimizationManagementClientBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public CarbonOptimizationManagementClientImpl buildClient() {
        String localEndpoint = this.endpoint != null ? this.endpoint : "https://management.azure.com";
        AzureEnvironment localEnvironment = this.environment != null ? this.environment : AzureEnvironment.AZURE;
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build();
        Duration localDefaultPollInterval = this.defaultPollInterval != null ? this.defaultPollInterval : Duration.ofSeconds(30L);
        SerializerAdapter localSerializerAdapter = this.serializerAdapter != null ? this.serializerAdapter : SerializerFactory.createDefaultManagementSerializerAdapter();
        CarbonOptimizationManagementClientImpl client = new CarbonOptimizationManagementClientImpl(localPipeline, localSerializerAdapter, localDefaultPollInterval, localEnvironment, localEndpoint);
        return client;
    }
}

