/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.DateRange;
import com.azure.resourcemanager.carbonoptimization.models.EmissionScopeEnum;
import com.azure.resourcemanager.carbonoptimization.models.QueryFilter;
import com.azure.resourcemanager.carbonoptimization.models.ReportTypeEnum;
import java.io.IOException;
import java.util.List;

public final class OverallSummaryReportQueryFilter
extends QueryFilter {
    private ReportTypeEnum reportType = ReportTypeEnum.OVERALL_SUMMARY_REPORT;
    private static final ClientLogger LOGGER = new ClientLogger(OverallSummaryReportQueryFilter.class);

    @Override
    public ReportTypeEnum reportType() {
        return this.reportType;
    }

    @Override
    public OverallSummaryReportQueryFilter withDateRange(DateRange dateRange) {
        super.withDateRange(dateRange);
        return this;
    }

    @Override
    public OverallSummaryReportQueryFilter withSubscriptionList(List<String> subscriptionList) {
        super.withSubscriptionList(subscriptionList);
        return this;
    }

    @Override
    public OverallSummaryReportQueryFilter withResourceGroupUrlList(List<String> resourceGroupUrlList) {
        super.withResourceGroupUrlList(resourceGroupUrlList);
        return this;
    }

    @Override
    public OverallSummaryReportQueryFilter withResourceTypeList(List<String> resourceTypeList) {
        super.withResourceTypeList(resourceTypeList);
        return this;
    }

    @Override
    public OverallSummaryReportQueryFilter withLocationList(List<String> locationList) {
        super.withLocationList(locationList);
        return this;
    }

    @Override
    public OverallSummaryReportQueryFilter withCarbonScopeList(List<EmissionScopeEnum> carbonScopeList) {
        super.withCarbonScopeList(carbonScopeList);
        return this;
    }

    @Override
    public void validate() {
        if (this.dateRange() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dateRange in model OverallSummaryReportQueryFilter"));
        }
        this.dateRange().validate();
        if (this.subscriptionList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionList in model OverallSummaryReportQueryFilter"));
        }
        if (this.carbonScopeList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property carbonScopeList in model OverallSummaryReportQueryFilter"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dateRange", (JsonSerializable)this.dateRange());
        jsonWriter.writeArrayField("subscriptionList", this.subscriptionList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("carbonScopeList", this.carbonScopeList(), (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("resourceGroupUrlList", this.resourceGroupUrlList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("resourceTypeList", this.resourceTypeList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("locationList", this.locationList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("reportType", this.reportType == null ? null : this.reportType.toString());
        return jsonWriter.writeEndObject();
    }

    public static OverallSummaryReportQueryFilter fromJson(JsonReader jsonReader) throws IOException {
        return (OverallSummaryReportQueryFilter)jsonReader.readObject(reader -> {
            OverallSummaryReportQueryFilter deserializedOverallSummaryReportQueryFilter = new OverallSummaryReportQueryFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dateRange".equals(fieldName)) {
                    deserializedOverallSummaryReportQueryFilter.withDateRange(DateRange.fromJson(reader));
                    continue;
                }
                if ("subscriptionList".equals(fieldName)) {
                    List subscriptionList = reader.readArray(reader1 -> reader1.getString());
                    deserializedOverallSummaryReportQueryFilter.withSubscriptionList(subscriptionList);
                    continue;
                }
                if ("carbonScopeList".equals(fieldName)) {
                    List carbonScopeList = reader.readArray(reader1 -> EmissionScopeEnum.fromString(reader1.getString()));
                    deserializedOverallSummaryReportQueryFilter.withCarbonScopeList(carbonScopeList);
                    continue;
                }
                if ("resourceGroupUrlList".equals(fieldName)) {
                    List resourceGroupUrlList = reader.readArray(reader1 -> reader1.getString());
                    deserializedOverallSummaryReportQueryFilter.withResourceGroupUrlList(resourceGroupUrlList);
                    continue;
                }
                if ("resourceTypeList".equals(fieldName)) {
                    List resourceTypeList = reader.readArray(reader1 -> reader1.getString());
                    deserializedOverallSummaryReportQueryFilter.withResourceTypeList(resourceTypeList);
                    continue;
                }
                if ("locationList".equals(fieldName)) {
                    List locationList = reader.readArray(reader1 -> reader1.getString());
                    deserializedOverallSummaryReportQueryFilter.withLocationList(locationList);
                    continue;
                }
                if ("reportType".equals(fieldName)) {
                    deserializedOverallSummaryReportQueryFilter.reportType = ReportTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOverallSummaryReportQueryFilter;
        });
    }
}

