/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionData;
import com.azure.resourcemanager.carbonoptimization.models.CategoryTypeEnum;
import com.azure.resourcemanager.carbonoptimization.models.ResponseDataTypeEnum;
import java.io.IOException;

public final class CarbonEmissionTopItemMonthlySummaryData
extends CarbonEmissionData {
    private ResponseDataTypeEnum dataType = ResponseDataTypeEnum.TOP_ITEMS_MONTHLY_SUMMARY_DATA;
    private String itemName;
    private CategoryTypeEnum categoryType;
    private String date;
    private static final ClientLogger LOGGER = new ClientLogger(CarbonEmissionTopItemMonthlySummaryData.class);

    private CarbonEmissionTopItemMonthlySummaryData() {
    }

    @Override
    public ResponseDataTypeEnum dataType() {
        return this.dataType;
    }

    public String itemName() {
        return this.itemName;
    }

    public CategoryTypeEnum categoryType() {
        return this.categoryType;
    }

    public String date() {
        return this.date;
    }

    @Override
    public void validate() {
        if (this.itemName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property itemName in model CarbonEmissionTopItemMonthlySummaryData"));
        }
        if (this.categoryType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property categoryType in model CarbonEmissionTopItemMonthlySummaryData"));
        }
        if (this.date() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property date in model CarbonEmissionTopItemMonthlySummaryData"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("latestMonthEmissions", this.latestMonthEmissions());
        jsonWriter.writeDoubleField("previousMonthEmissions", this.previousMonthEmissions());
        jsonWriter.writeNumberField("monthOverMonthEmissionsChangeRatio", (Number)this.monthOverMonthEmissionsChangeRatio());
        jsonWriter.writeNumberField("monthlyEmissionsChangeValue", (Number)this.monthlyEmissionsChangeValue());
        jsonWriter.writeStringField("itemName", this.itemName);
        jsonWriter.writeStringField("categoryType", this.categoryType == null ? null : this.categoryType.toString());
        jsonWriter.writeStringField("date", this.date);
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        return jsonWriter.writeEndObject();
    }

    public static CarbonEmissionTopItemMonthlySummaryData fromJson(JsonReader jsonReader) throws IOException {
        return (CarbonEmissionTopItemMonthlySummaryData)jsonReader.readObject(reader -> {
            CarbonEmissionTopItemMonthlySummaryData deserializedCarbonEmissionTopItemMonthlySummaryData = new CarbonEmissionTopItemMonthlySummaryData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("latestMonthEmissions".equals(fieldName)) {
                    deserializedCarbonEmissionTopItemMonthlySummaryData.withLatestMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("previousMonthEmissions".equals(fieldName)) {
                    deserializedCarbonEmissionTopItemMonthlySummaryData.withPreviousMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("monthOverMonthEmissionsChangeRatio".equals(fieldName)) {
                    deserializedCarbonEmissionTopItemMonthlySummaryData.withMonthOverMonthEmissionsChangeRatio((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("monthlyEmissionsChangeValue".equals(fieldName)) {
                    deserializedCarbonEmissionTopItemMonthlySummaryData.withMonthlyEmissionsChangeValue((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("itemName".equals(fieldName)) {
                    deserializedCarbonEmissionTopItemMonthlySummaryData.itemName = reader.getString();
                    continue;
                }
                if ("categoryType".equals(fieldName)) {
                    deserializedCarbonEmissionTopItemMonthlySummaryData.categoryType = CategoryTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("date".equals(fieldName)) {
                    deserializedCarbonEmissionTopItemMonthlySummaryData.date = reader.getString();
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    deserializedCarbonEmissionTopItemMonthlySummaryData.dataType = ResponseDataTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCarbonEmissionTopItemMonthlySummaryData;
        });
    }
}

