/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionData;
import com.azure.resourcemanager.carbonoptimization.models.CategoryTypeEnum;
import com.azure.resourcemanager.carbonoptimization.models.ResponseDataTypeEnum;
import java.io.IOException;

public final class CarbonEmissionItemDetailData
extends CarbonEmissionData {
    private ResponseDataTypeEnum dataType = ResponseDataTypeEnum.ITEM_DETAILS_DATA;
    private String itemName;
    private CategoryTypeEnum categoryType;
    private static final ClientLogger LOGGER = new ClientLogger(CarbonEmissionItemDetailData.class);

    private CarbonEmissionItemDetailData() {
    }

    @Override
    public ResponseDataTypeEnum dataType() {
        return this.dataType;
    }

    public String itemName() {
        return this.itemName;
    }

    public CategoryTypeEnum categoryType() {
        return this.categoryType;
    }

    @Override
    public void validate() {
        if (this.itemName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property itemName in model CarbonEmissionItemDetailData"));
        }
        if (this.categoryType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property categoryType in model CarbonEmissionItemDetailData"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("latestMonthEmissions", this.latestMonthEmissions());
        jsonWriter.writeDoubleField("previousMonthEmissions", this.previousMonthEmissions());
        jsonWriter.writeNumberField("monthOverMonthEmissionsChangeRatio", (Number)this.monthOverMonthEmissionsChangeRatio());
        jsonWriter.writeNumberField("monthlyEmissionsChangeValue", (Number)this.monthlyEmissionsChangeValue());
        jsonWriter.writeStringField("itemName", this.itemName);
        jsonWriter.writeStringField("categoryType", this.categoryType == null ? null : this.categoryType.toString());
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        return jsonWriter.writeEndObject();
    }

    public static CarbonEmissionItemDetailData fromJson(JsonReader jsonReader) throws IOException {
        return (CarbonEmissionItemDetailData)jsonReader.readObject(reader -> {
            CarbonEmissionItemDetailData deserializedCarbonEmissionItemDetailData = new CarbonEmissionItemDetailData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("latestMonthEmissions".equals(fieldName)) {
                    deserializedCarbonEmissionItemDetailData.withLatestMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("previousMonthEmissions".equals(fieldName)) {
                    deserializedCarbonEmissionItemDetailData.withPreviousMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("monthOverMonthEmissionsChangeRatio".equals(fieldName)) {
                    deserializedCarbonEmissionItemDetailData.withMonthOverMonthEmissionsChangeRatio((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("monthlyEmissionsChangeValue".equals(fieldName)) {
                    deserializedCarbonEmissionItemDetailData.withMonthlyEmissionsChangeValue((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("itemName".equals(fieldName)) {
                    deserializedCarbonEmissionItemDetailData.itemName = reader.getString();
                    continue;
                }
                if ("categoryType".equals(fieldName)) {
                    deserializedCarbonEmissionItemDetailData.categoryType = CategoryTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    deserializedCarbonEmissionItemDetailData.dataType = ResponseDataTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCarbonEmissionItemDetailData;
        });
    }
}

