/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ContactsOrgContactsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfOrgContact;
import com.azure.resourcemanager.authorization.fluent.models.Get2ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get3ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get6ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get7ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get8ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOrgContactInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ContactsOrgContactsClientImpl
implements ContactsOrgContactsClient {
    private final ClientLogger logger = new ClientLogger(ContactsOrgContactsClientImpl.class);
    private final ContactsOrgContactsService service;
    private final MicrosoftGraphClientImpl client;

    ContactsOrgContactsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (ContactsOrgContactsService)RestProxy.create(ContactsOrgContactsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrgContactInner>> listOrgContactSinglePageAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listOrgContact(this.client.getEndpoint(), consistencyLevel, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOrgContact)res.getValue()).value(), ((CollectionOfOrgContact)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrgContactInner>> listOrgContactSinglePageAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listOrgContact(this.client.getEndpoint(), consistencyLevel, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOrgContact)res.getValue()).value(), ((CollectionOfOrgContact)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOrgContactInner> listOrgContactAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand) {
        return new PagedFlux(() -> this.listOrgContactSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOrgContactInner> listOrgContactAsync() {
        String consistencyLevel = null;
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listOrgContactSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphOrgContactInner> listOrgContactAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand, Context context) {
        return new PagedFlux(() -> this.listOrgContactSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOrgContactInner> listOrgContact() {
        String consistencyLevel = null;
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<Get6ItemsItem> orderby = null;
        List<Get7ItemsItem> select = null;
        List<Get8ItemsItem> expand = null;
        return new PagedIterable(this.listOrgContactAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOrgContactInner> listOrgContact(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand, Context context) {
        return new PagedIterable(this.listOrgContactAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphOrgContactInner>> createOrgContactWithResponseAsync(MicrosoftGraphOrgContactInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrgContact(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphOrgContactInner>> createOrgContactWithResponseAsync(MicrosoftGraphOrgContactInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrgContact(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphOrgContactInner> createOrgContactAsync(MicrosoftGraphOrgContactInner body) {
        return this.createOrgContactWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphOrgContactInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphOrgContactInner createOrgContact(MicrosoftGraphOrgContactInner body) {
        return (MicrosoftGraphOrgContactInner)this.createOrgContactAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphOrgContactInner> createOrgContactWithResponse(MicrosoftGraphOrgContactInner body, Context context) {
        return (Response)this.createOrgContactWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphOrgContactInner>> getOrgContactWithResponseAsync(String orgContactId, String consistencyLevel, List<Get2ItemsItem> select, List<Get3ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getOrgContact(this.client.getEndpoint(), orgContactId, consistencyLevel, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphOrgContactInner>> getOrgContactWithResponseAsync(String orgContactId, String consistencyLevel, List<Get2ItemsItem> select, List<Get3ItemsItem> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getOrgContact(this.client.getEndpoint(), orgContactId, consistencyLevel, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphOrgContactInner> getOrgContactAsync(String orgContactId, String consistencyLevel, List<Get2ItemsItem> select, List<Get3ItemsItem> expand) {
        return this.getOrgContactWithResponseAsync(orgContactId, consistencyLevel, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphOrgContactInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphOrgContactInner> getOrgContactAsync(String orgContactId) {
        String consistencyLevel = null;
        List<Get2ItemsItem> select = null;
        List<Get3ItemsItem> expand = null;
        return this.getOrgContactWithResponseAsync(orgContactId, consistencyLevel, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphOrgContactInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphOrgContactInner getOrgContact(String orgContactId) {
        String consistencyLevel = null;
        List<Get2ItemsItem> select = null;
        List<Get3ItemsItem> expand = null;
        return (MicrosoftGraphOrgContactInner)this.getOrgContactAsync(orgContactId, consistencyLevel, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphOrgContactInner> getOrgContactWithResponse(String orgContactId, String consistencyLevel, List<Get2ItemsItem> select, List<Get3ItemsItem> expand, Context context) {
        return (Response)this.getOrgContactWithResponseAsync(orgContactId, consistencyLevel, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateOrgContactWithResponseAsync(String orgContactId, MicrosoftGraphOrgContactInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateOrgContact(this.client.getEndpoint(), orgContactId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateOrgContactWithResponseAsync(String orgContactId, MicrosoftGraphOrgContactInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateOrgContact(this.client.getEndpoint(), orgContactId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateOrgContactAsync(String orgContactId, MicrosoftGraphOrgContactInner body) {
        return this.updateOrgContactWithResponseAsync(orgContactId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateOrgContact(String orgContactId, MicrosoftGraphOrgContactInner body) {
        this.updateOrgContactAsync(orgContactId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateOrgContactWithResponse(String orgContactId, MicrosoftGraphOrgContactInner body, Context context) {
        return (Response)this.updateOrgContactWithResponseAsync(orgContactId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteOrgContactWithResponseAsync(String orgContactId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteOrgContact(this.client.getEndpoint(), orgContactId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteOrgContactWithResponseAsync(String orgContactId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteOrgContact(this.client.getEndpoint(), orgContactId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteOrgContactAsync(String orgContactId, String ifMatch) {
        return this.deleteOrgContactWithResponseAsync(orgContactId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteOrgContactAsync(String orgContactId) {
        String ifMatch = null;
        return this.deleteOrgContactWithResponseAsync(orgContactId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteOrgContact(String orgContactId) {
        String ifMatch = null;
        this.deleteOrgContactAsync(orgContactId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteOrgContactWithResponse(String orgContactId, String ifMatch, Context context) {
        return (Response)this.deleteOrgContactWithResponseAsync(orgContactId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrgContactInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOrgContact)res.getValue()).value(), ((CollectionOfOrgContact)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrgContactInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOrgContact)res.getValue()).value(), ((CollectionOfOrgContact)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface ContactsOrgContactsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfOrgContact>> listOrgContact(@HostParam(value="$host") String var1, @HeaderParam(value="ConsistencyLevel") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contacts")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphOrgContactInner>> createOrgContact(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphOrgContactInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contacts/{orgContact-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphOrgContactInner>> getOrgContact(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @HeaderParam(value="ConsistencyLevel") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/contacts/{orgContact-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateOrgContact(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @BodyParam(value="application/json") MicrosoftGraphOrgContactInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/contacts/{orgContact-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteOrgContact(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfOrgContact>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

