/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteEntitySchemaObjectModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public class MicrosoftGraphOnenoteEntityHierarchyModel
extends MicrosoftGraphOnenoteEntitySchemaObjectModel {
    private MicrosoftGraphIdentitySet createdBy;
    private String displayName;
    private MicrosoftGraphIdentitySet lastModifiedBy;
    private OffsetDateTime lastModifiedDateTime;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphIdentitySet createdBy() {
        return this.createdBy;
    }

    public MicrosoftGraphOnenoteEntityHierarchyModel withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphOnenoteEntityHierarchyModel withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public MicrosoftGraphIdentitySet lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public MicrosoftGraphOnenoteEntityHierarchyModel withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphOnenoteEntityHierarchyModel withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOnenoteEntityHierarchyModel withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteEntityHierarchyModel withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteEntityHierarchyModel withSelf(String self) {
        super.withSelf(self);
        return this;
    }

    @Override
    public MicrosoftGraphOnenoteEntityHierarchyModel withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.createdBy() != null) {
            this.createdBy().validate();
        }
        if (this.lastModifiedBy() != null) {
            this.lastModifiedBy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("self", this.self());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeJsonField("createdBy", (JsonSerializable)this.createdBy);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy);
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOnenoteEntityHierarchyModel fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOnenoteEntityHierarchyModel)jsonReader.readObject(reader -> {
            MicrosoftGraphOnenoteEntityHierarchyModel deserializedMicrosoftGraphOnenoteEntityHierarchyModel = new MicrosoftGraphOnenoteEntityHierarchyModel();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteEntityHierarchyModel.withId(reader.getString());
                    continue;
                }
                if ("self".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteEntityHierarchyModel.withSelf(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteEntityHierarchyModel.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteEntityHierarchyModel.createdBy = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteEntityHierarchyModel.displayName = reader.getString();
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteEntityHierarchyModel.lastModifiedBy = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteEntityHierarchyModel.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOnenoteEntityHierarchyModel.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOnenoteEntityHierarchyModel;
        });
    }
}

