/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphStsPolicy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphTokenIssuancePolicy
extends MicrosoftGraphStsPolicy {
    private Map<String, Object> additionalProperties;

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphTokenIssuancePolicy withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphTokenIssuancePolicy withDefinition(List<String> definition) {
        super.withDefinition(definition);
        return this;
    }

    @Override
    public MicrosoftGraphTokenIssuancePolicy withIsOrganizationDefault(Boolean isOrganizationDefault) {
        super.withIsOrganizationDefault(isOrganizationDefault);
        return this;
    }

    @Override
    public MicrosoftGraphTokenIssuancePolicy withAppliesTo(List<MicrosoftGraphDirectoryObjectInner> appliesTo) {
        super.withAppliesTo(appliesTo);
        return this;
    }

    @Override
    public MicrosoftGraphTokenIssuancePolicy withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public MicrosoftGraphTokenIssuancePolicy withDisplayName(String displayName) {
        super.withDisplayName(displayName);
        return this;
    }

    @Override
    public MicrosoftGraphTokenIssuancePolicy withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphTokenIssuancePolicy withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("deletedDateTime", this.deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedDateTime()));
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("displayName", this.displayName());
        jsonWriter.writeArrayField("definition", this.definition(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isOrganizationDefault", this.isOrganizationDefault());
        jsonWriter.writeArrayField("appliesTo", this.appliesTo(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphTokenIssuancePolicy fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphTokenIssuancePolicy)jsonReader.readObject(reader -> {
            MicrosoftGraphTokenIssuancePolicy deserializedMicrosoftGraphTokenIssuancePolicy = new MicrosoftGraphTokenIssuancePolicy();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTokenIssuancePolicy.withId(reader.getString());
                    continue;
                }
                if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTokenIssuancePolicy.withDeletedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphTokenIssuancePolicy.withDescription(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphTokenIssuancePolicy.withDisplayName(reader.getString());
                    continue;
                }
                if ("definition".equals(fieldName)) {
                    List definition = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphTokenIssuancePolicy.withDefinition(definition);
                    continue;
                }
                if ("isOrganizationDefault".equals(fieldName)) {
                    deserializedMicrosoftGraphTokenIssuancePolicy.withIsOrganizationDefault((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("appliesTo".equals(fieldName)) {
                    List appliesTo = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphTokenIssuancePolicy.withAppliesTo(appliesTo);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphTokenIssuancePolicy.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphTokenIssuancePolicy;
        });
    }
}

