/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MicrosoftGraphOutlookItem
extends MicrosoftGraphEntity {
    private List<String> categories;
    private String changeKey;
    private OffsetDateTime createdDateTime;
    private OffsetDateTime lastModifiedDateTime;
    private Map<String, Object> additionalProperties;

    public List<String> categories() {
        return this.categories;
    }

    public MicrosoftGraphOutlookItem withCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    public String changeKey() {
        return this.changeKey;
    }

    public MicrosoftGraphOutlookItem withChangeKey(String changeKey) {
        this.changeKey = changeKey;
        return this;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public MicrosoftGraphOutlookItem withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphOutlookItem withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOutlookItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOutlookItem withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeArrayField("categories", this.categories, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("changeKey", this.changeKey);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOutlookItem fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOutlookItem)jsonReader.readObject(reader -> {
            MicrosoftGraphOutlookItem deserializedMicrosoftGraphOutlookItem = new MicrosoftGraphOutlookItem();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOutlookItem.withId(reader.getString());
                    continue;
                }
                if ("categories".equals(fieldName)) {
                    List categories;
                    deserializedMicrosoftGraphOutlookItem.categories = categories = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("changeKey".equals(fieldName)) {
                    deserializedMicrosoftGraphOutlookItem.changeKey = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOutlookItem.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOutlookItem.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOutlookItem.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOutlookItem;
        });
    }
}

