/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphChannelMembershipType;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphChatMessage;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphConversationMember;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDriveItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTeamsTab;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphChannel
extends MicrosoftGraphEntity {
    private String description;
    private String displayName;
    private String email;
    private Boolean isFavoriteByDefault;
    private MicrosoftGraphChannelMembershipType membershipType;
    private String webUrl;
    private MicrosoftGraphDriveItem filesFolder;
    private List<MicrosoftGraphConversationMember> members;
    private List<MicrosoftGraphChatMessage> messages;
    private List<MicrosoftGraphTeamsTab> tabs;
    private Map<String, Object> additionalProperties;

    public String description() {
        return this.description;
    }

    public MicrosoftGraphChannel withDescription(String description) {
        this.description = description;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphChannel withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String email() {
        return this.email;
    }

    public MicrosoftGraphChannel withEmail(String email) {
        this.email = email;
        return this;
    }

    public Boolean isFavoriteByDefault() {
        return this.isFavoriteByDefault;
    }

    public MicrosoftGraphChannel withIsFavoriteByDefault(Boolean isFavoriteByDefault) {
        this.isFavoriteByDefault = isFavoriteByDefault;
        return this;
    }

    public MicrosoftGraphChannelMembershipType membershipType() {
        return this.membershipType;
    }

    public MicrosoftGraphChannel withMembershipType(MicrosoftGraphChannelMembershipType membershipType) {
        this.membershipType = membershipType;
        return this;
    }

    public String webUrl() {
        return this.webUrl;
    }

    public MicrosoftGraphChannel withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    public MicrosoftGraphDriveItem filesFolder() {
        return this.filesFolder;
    }

    public MicrosoftGraphChannel withFilesFolder(MicrosoftGraphDriveItem filesFolder) {
        this.filesFolder = filesFolder;
        return this;
    }

    public List<MicrosoftGraphConversationMember> members() {
        return this.members;
    }

    public MicrosoftGraphChannel withMembers(List<MicrosoftGraphConversationMember> members) {
        this.members = members;
        return this;
    }

    public List<MicrosoftGraphChatMessage> messages() {
        return this.messages;
    }

    public MicrosoftGraphChannel withMessages(List<MicrosoftGraphChatMessage> messages) {
        this.messages = messages;
        return this;
    }

    public List<MicrosoftGraphTeamsTab> tabs() {
        return this.tabs;
    }

    public MicrosoftGraphChannel withTabs(List<MicrosoftGraphTeamsTab> tabs) {
        this.tabs = tabs;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphChannel withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphChannel withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.filesFolder() != null) {
            this.filesFolder().validate();
        }
        if (this.members() != null) {
            this.members().forEach(e -> e.validate());
        }
        if (this.messages() != null) {
            this.messages().forEach(e -> e.validate());
        }
        if (this.tabs() != null) {
            this.tabs().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeBooleanField("isFavoriteByDefault", this.isFavoriteByDefault);
        jsonWriter.writeStringField("membershipType", this.membershipType == null ? null : this.membershipType.toString());
        jsonWriter.writeStringField("webUrl", this.webUrl);
        jsonWriter.writeJsonField("filesFolder", (JsonSerializable)this.filesFolder);
        jsonWriter.writeArrayField("members", this.members, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("tabs", this.tabs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphChannel fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphChannel)jsonReader.readObject(reader -> {
            MicrosoftGraphChannel deserializedMicrosoftGraphChannel = new MicrosoftGraphChannel();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.withId(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.description = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.displayName = reader.getString();
                    continue;
                }
                if ("email".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.email = reader.getString();
                    continue;
                }
                if ("isFavoriteByDefault".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.isFavoriteByDefault = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("membershipType".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.membershipType = MicrosoftGraphChannelMembershipType.fromString(reader.getString());
                    continue;
                }
                if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.webUrl = reader.getString();
                    continue;
                }
                if ("filesFolder".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.filesFolder = MicrosoftGraphDriveItem.fromJson(reader);
                    continue;
                }
                if ("members".equals(fieldName)) {
                    List members;
                    deserializedMicrosoftGraphChannel.members = members = reader.readArray(reader1 -> MicrosoftGraphConversationMember.fromJson(reader1));
                    continue;
                }
                if ("messages".equals(fieldName)) {
                    List messages;
                    deserializedMicrosoftGraphChannel.messages = messages = reader.readArray(reader1 -> MicrosoftGraphChatMessage.fromJson(reader1));
                    continue;
                }
                if ("tabs".equals(fieldName)) {
                    List tabs;
                    deserializedMicrosoftGraphChannel.tabs = tabs = reader.readArray(reader1 -> MicrosoftGraphTeamsTab.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphChannel.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphChannel;
        });
    }
}

