/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphSharingInvitation
implements JsonSerializable<MicrosoftGraphSharingInvitation> {
    private String email;
    private MicrosoftGraphIdentitySet invitedBy;
    private String redeemedBy;
    private Boolean signInRequired;
    private Map<String, Object> additionalProperties;

    public String email() {
        return this.email;
    }

    public MicrosoftGraphSharingInvitation withEmail(String email) {
        this.email = email;
        return this;
    }

    public MicrosoftGraphIdentitySet invitedBy() {
        return this.invitedBy;
    }

    public MicrosoftGraphSharingInvitation withInvitedBy(MicrosoftGraphIdentitySet invitedBy) {
        this.invitedBy = invitedBy;
        return this;
    }

    public String redeemedBy() {
        return this.redeemedBy;
    }

    public MicrosoftGraphSharingInvitation withRedeemedBy(String redeemedBy) {
        this.redeemedBy = redeemedBy;
        return this;
    }

    public Boolean signInRequired() {
        return this.signInRequired;
    }

    public MicrosoftGraphSharingInvitation withSignInRequired(Boolean signInRequired) {
        this.signInRequired = signInRequired;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphSharingInvitation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.invitedBy() != null) {
            this.invitedBy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeJsonField("invitedBy", (JsonSerializable)this.invitedBy);
        jsonWriter.writeStringField("redeemedBy", this.redeemedBy);
        jsonWriter.writeBooleanField("signInRequired", this.signInRequired);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphSharingInvitation fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphSharingInvitation)jsonReader.readObject(reader -> {
            MicrosoftGraphSharingInvitation deserializedMicrosoftGraphSharingInvitation = new MicrosoftGraphSharingInvitation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("email".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingInvitation.email = reader.getString();
                    continue;
                }
                if ("invitedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingInvitation.invitedBy = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("redeemedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingInvitation.redeemedBy = reader.getString();
                    continue;
                }
                if ("signInRequired".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingInvitation.signInRequired = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphSharingInvitation.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphSharingInvitation;
        });
    }
}

